/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * To provide stable, secure, efficient, and easy-to-use cloud storage service
 * on Huawei Cloud
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface OBSEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the Huawei Object Storage Service (OBS) component.
     */
    public interface OBSEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedOBSEndpointConsumerBuilder advanced() {
            return (AdvancedOBSEndpointConsumerBuilder) this;
        }
        /**
         * Name of bucket to perform operation on.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param bucketName the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder bucketName(String bucketName) {
            doSetProperty("bucketName", bucketName);
            return this;
        }
        /**
         * OBS url. Carries higher precedence than region parameter based client
         * initialization.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param endpoint the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder endpoint(String endpoint) {
            doSetProperty("endpoint", endpoint);
            return this;
        }
        /**
         * Name of object to perform operation with.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param objectName the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder objectName(String objectName) {
            doSetProperty("objectName", objectName);
            return this;
        }
        /**
         * OBS service region. This is lower precedence than endpoint based
         * configuration.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Determines if objects should be deleted after it has been retrieved.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder deleteAfterRead(boolean deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * Determines if objects should be deleted after it has been retrieved.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder deleteAfterRead(String deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * The character used for grouping object names.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder delimiter(String delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * Name of destination bucket where objects will be moved when
         * moveAfterRead is set to true.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param destinationBucket the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder destinationBucket(String destinationBucket) {
            doSetProperty("destinationBucket", destinationBucket);
            return this;
        }
        /**
         * Get the object from the bucket with the given file name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param fileName the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder fileName(String fileName) {
            doSetProperty("fileName", fileName);
            return this;
        }
        /**
         * If true, objects in folders will be consumed. Otherwise, they will be
         * ignored and no Exchanges will be created for them.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeFolders the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder includeFolders(boolean includeFolders) {
            doSetProperty("includeFolders", includeFolders);
            return this;
        }
        /**
         * If true, objects in folders will be consumed. Otherwise, they will be
         * ignored and no Exchanges will be created for them.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeFolders the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder includeFolders(String includeFolders) {
            doSetProperty("includeFolders", includeFolders);
            return this;
        }
        /**
         * The maximum number of messages to poll at each polling.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder maxMessagesPerPoll(int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * The maximum number of messages to poll at each polling.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder maxMessagesPerPoll(String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * Determines whether objects should be moved to a different bucket
         * after they have been retrieved. The destinationBucket option must
         * also be set for this option to work.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param moveAfterRead the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder moveAfterRead(boolean moveAfterRead) {
            doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }
        /**
         * Determines whether objects should be moved to a different bucket
         * after they have been retrieved. The destinationBucket option must
         * also be set for this option to work.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param moveAfterRead the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder moveAfterRead(String moveAfterRead) {
            doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }
        /**
         * The object name prefix used for filtering objects to be listed.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Proxy server ip/hostname.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * Proxy authentication password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPassword the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder proxyPassword(String proxyPassword) {
            doSetProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * Proxy server port.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder proxyPort(int proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Proxy server port.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Proxy authentication user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyUser the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder proxyUser(String proxyUser) {
            doSetProperty("proxyUser", proxyUser);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder runLoggingLevel(org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler. This is a multi-value
         * option with prefix: scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder schedulerProperties(String key, Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler. This is a multi-value
         * option with prefix: scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder startScheduler(boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Access key for the cloud user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Ignore SSL verification.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ignoreSslVerification the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder ignoreSslVerification(boolean ignoreSslVerification) {
            doSetProperty("ignoreSslVerification", ignoreSslVerification);
            return this;
        }
        /**
         * Ignore SSL verification.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ignoreSslVerification the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder ignoreSslVerification(String ignoreSslVerification) {
            doSetProperty("ignoreSslVerification", ignoreSslVerification);
            return this;
        }
        /**
         * Secret key for the cloud user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Configuration object for cloud service authentication.
         * 
         * The option is a:
         * <code>org.apache.camel.component.huaweicloud.common.models.ServiceKeys</code> type.
         * 
         * Group: security
         * 
         * @param serviceKeys the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder serviceKeys(org.apache.camel.component.huaweicloud.common.models.ServiceKeys serviceKeys) {
            doSetProperty("serviceKeys", serviceKeys);
            return this;
        }
        /**
         * Configuration object for cloud service authentication.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.huaweicloud.common.models.ServiceKeys</code> type.
         * 
         * Group: security
         * 
         * @param serviceKeys the value to set
         * @return the dsl builder
         */
        default OBSEndpointConsumerBuilder serviceKeys(String serviceKeys) {
            doSetProperty("serviceKeys", serviceKeys);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Huawei Object Storage Service (OBS) component.
     */
    public interface AdvancedOBSEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default OBSEndpointConsumerBuilder basic() {
            return (OBSEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOBSEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOBSEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOBSEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOBSEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedOBSEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedOBSEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedOBSEndpointConsumerBuilder pollStrategy(org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedOBSEndpointConsumerBuilder pollStrategy(String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Huawei Object Storage Service (OBS) component.
     */
    public interface OBSEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedOBSEndpointProducerBuilder advanced() {
            return (AdvancedOBSEndpointProducerBuilder) this;
        }

        /**
         * Name of bucket to perform operation on.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param bucketName the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder bucketName(String bucketName) {
            doSetProperty("bucketName", bucketName);
            return this;
        }
        /**
         * OBS url. Carries higher precedence than region parameter based client
         * initialization.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param endpoint the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder endpoint(String endpoint) {
            doSetProperty("endpoint", endpoint);
            return this;
        }
        /**
         * Name of object to perform operation with.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param objectName the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder objectName(String objectName) {
            doSetProperty("objectName", objectName);
            return this;
        }
        /**
         * OBS service region. This is lower precedence than endpoint based
         * configuration.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Location of bucket when creating a new bucket.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param bucketLocation the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder bucketLocation(String bucketLocation) {
            doSetProperty("bucketLocation", bucketLocation);
            return this;
        }
        /**
         * Proxy server ip/hostname.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * Proxy authentication password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPassword the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder proxyPassword(String proxyPassword) {
            doSetProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * Proxy server port.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder proxyPort(int proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Proxy server port.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Proxy authentication user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyUser the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder proxyUser(String proxyUser) {
            doSetProperty("proxyUser", proxyUser);
            return this;
        }
        /**
         * Access key for the cloud user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Ignore SSL verification.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ignoreSslVerification the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder ignoreSslVerification(boolean ignoreSslVerification) {
            doSetProperty("ignoreSslVerification", ignoreSslVerification);
            return this;
        }
        /**
         * Ignore SSL verification.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ignoreSslVerification the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder ignoreSslVerification(String ignoreSslVerification) {
            doSetProperty("ignoreSslVerification", ignoreSslVerification);
            return this;
        }
        /**
         * Secret key for the cloud user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Configuration object for cloud service authentication.
         * 
         * The option is a:
         * <code>org.apache.camel.component.huaweicloud.common.models.ServiceKeys</code> type.
         * 
         * Group: security
         * 
         * @param serviceKeys the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder serviceKeys(org.apache.camel.component.huaweicloud.common.models.ServiceKeys serviceKeys) {
            doSetProperty("serviceKeys", serviceKeys);
            return this;
        }
        /**
         * Configuration object for cloud service authentication.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.huaweicloud.common.models.ServiceKeys</code> type.
         * 
         * Group: security
         * 
         * @param serviceKeys the value to set
         * @return the dsl builder
         */
        default OBSEndpointProducerBuilder serviceKeys(String serviceKeys) {
            doSetProperty("serviceKeys", serviceKeys);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Huawei Object Storage Service (OBS) component.
     */
    public interface AdvancedOBSEndpointProducerBuilder extends EndpointProducerBuilder {
        default OBSEndpointProducerBuilder basic() {
            return (OBSEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedOBSEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedOBSEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Huawei Object Storage Service (OBS) component.
     */
    public interface OBSEndpointBuilder
            extends
                OBSEndpointConsumerBuilder,
                OBSEndpointProducerBuilder {
        default AdvancedOBSEndpointBuilder advanced() {
            return (AdvancedOBSEndpointBuilder) this;
        }

        /**
         * Name of bucket to perform operation on.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param bucketName the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder bucketName(String bucketName) {
            doSetProperty("bucketName", bucketName);
            return this;
        }
        /**
         * OBS url. Carries higher precedence than region parameter based client
         * initialization.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param endpoint the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder endpoint(String endpoint) {
            doSetProperty("endpoint", endpoint);
            return this;
        }
        /**
         * Name of object to perform operation with.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param objectName the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder objectName(String objectName) {
            doSetProperty("objectName", objectName);
            return this;
        }
        /**
         * OBS service region. This is lower precedence than endpoint based
         * configuration.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Proxy server ip/hostname.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * Proxy authentication password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPassword the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder proxyPassword(String proxyPassword) {
            doSetProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * Proxy server port.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder proxyPort(int proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Proxy server port.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Proxy authentication user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyUser the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder proxyUser(String proxyUser) {
            doSetProperty("proxyUser", proxyUser);
            return this;
        }
        /**
         * Access key for the cloud user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Ignore SSL verification.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ignoreSslVerification the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder ignoreSslVerification(boolean ignoreSslVerification) {
            doSetProperty("ignoreSslVerification", ignoreSslVerification);
            return this;
        }
        /**
         * Ignore SSL verification.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ignoreSslVerification the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder ignoreSslVerification(String ignoreSslVerification) {
            doSetProperty("ignoreSslVerification", ignoreSslVerification);
            return this;
        }
        /**
         * Secret key for the cloud user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Configuration object for cloud service authentication.
         * 
         * The option is a:
         * <code>org.apache.camel.component.huaweicloud.common.models.ServiceKeys</code> type.
         * 
         * Group: security
         * 
         * @param serviceKeys the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder serviceKeys(org.apache.camel.component.huaweicloud.common.models.ServiceKeys serviceKeys) {
            doSetProperty("serviceKeys", serviceKeys);
            return this;
        }
        /**
         * Configuration object for cloud service authentication.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.huaweicloud.common.models.ServiceKeys</code> type.
         * 
         * Group: security
         * 
         * @param serviceKeys the value to set
         * @return the dsl builder
         */
        default OBSEndpointBuilder serviceKeys(String serviceKeys) {
            doSetProperty("serviceKeys", serviceKeys);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Huawei Object Storage Service (OBS) component.
     */
    public interface AdvancedOBSEndpointBuilder
            extends
                AdvancedOBSEndpointConsumerBuilder,
                AdvancedOBSEndpointProducerBuilder {
        default OBSEndpointBuilder basic() {
            return (OBSEndpointBuilder) this;
        }

    }

    public interface OBSBuilders {
        /**
         * Huawei Object Storage Service (OBS) (camel-huaweicloud-obs)
         * To provide stable, secure, efficient, and easy-to-use cloud storage
         * service on Huawei Cloud
         * 
         * Category: cloud
         * Since: 3.12
         * Maven coordinates: org.apache.camel:camel-huaweicloud-obs
         * 
         * @return the dsl builder for the headers' name.
         */
        default OBSHeaderNameBuilder hwcloudObs() {
            return OBSHeaderNameBuilder.INSTANCE;
        }
        /**
         * Huawei Object Storage Service (OBS) (camel-huaweicloud-obs)
         * To provide stable, secure, efficient, and easy-to-use cloud storage
         * service on Huawei Cloud
         * 
         * Category: cloud
         * Since: 3.12
         * Maven coordinates: org.apache.camel:camel-huaweicloud-obs
         * 
         * Syntax: <code>hwcloud-obs:operation</code>
         * 
         * Path parameter: operation (required)
         * Operation to be performed
         * 
         * @param path operation
         * @return the dsl builder
         */
        default OBSEndpointBuilder hwcloudObs(String path) {
            return OBSEndpointBuilderFactory.endpointBuilder("hwcloud-obs", path);
        }
        /**
         * Huawei Object Storage Service (OBS) (camel-huaweicloud-obs)
         * To provide stable, secure, efficient, and easy-to-use cloud storage
         * service on Huawei Cloud
         * 
         * Category: cloud
         * Since: 3.12
         * Maven coordinates: org.apache.camel:camel-huaweicloud-obs
         * 
         * Syntax: <code>hwcloud-obs:operation</code>
         * 
         * Path parameter: operation (required)
         * Operation to be performed
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path operation
         * @return the dsl builder
         */
        default OBSEndpointBuilder hwcloudObs(String componentName, String path) {
            return OBSEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Huawei Object Storage Service (OBS) component.
     */
    public static class OBSHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final OBSHeaderNameBuilder INSTANCE = new OBSHeaderNameBuilder();

        /**
         * Name of the bucket where object is contained.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code HwCloudObsBucketName}.
         */
        public String hwCloudObsBucketName() {
            return "CamelHwCloudObsBucketName";
        }
        /**
         * The key that the object is stored under.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code HwCloudObsObjectKey}.
         */
        public String hwCloudObsObjectKey() {
            return "CamelHwCloudObsObjectKey";
        }
        /**
         * The date and time that the object was last modified.
         * 
         * The option is a: {@code Date} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code HwCloudObsLastModified}.
         */
        public String hwCloudObsLastModified() {
            return "CamelHwCloudObsLastModified";
        }
        /**
         * The 128-bit MD5 digest of the Base64 code of the object. This data is
         * the unique identifier of the object content.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code HwCloudObsETag}.
         */
        public String hwCloudObsETag() {
            return "CamelHwCloudObsETag";
        }
        /**
         * The 128-bit Base64-encoded digest used to decrypt the object.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code HwCloudObsContentMD5}.
         */
        public String hwCloudObsContentMD5() {
            return "CamelHwCloudObsContentMD5";
        }
        /**
         * Shows whether the object is a file or a folder.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code HwCloudObsObjectType}.
         */
        public String hwCloudObsObjectType() {
            return "CamelHwCloudObsObjectType";
        }
        /**
         * The size of the object body in bytes.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code Content-Length}.
         */
        public String contentLength() {
            return "Content-Length";
        }
        /**
         * The type of content stored in the object.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code Content-Type}.
         */
        public String contentType() {
            return "Content-Type";
        }
        /**
         * Name of the object with which the operation is to be performed.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileName}.
         */
        public String fileName() {
            return "CamelFileName";
        }
    }
    static OBSEndpointBuilder endpointBuilder(String componentName, String path) {
        class OBSEndpointBuilderImpl extends AbstractEndpointBuilder implements OBSEndpointBuilder, AdvancedOBSEndpointBuilder {
            public OBSEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new OBSEndpointBuilderImpl(path);
    }
}