/*
 * Camel ApiCollection generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.as2.internal;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2ClientManagerEndpointConfiguration;
import org.apache.camel.component.as2.AS2ServerManagerEndpointConfiguration;
import org.apache.camel.component.as2.AS2AsyncMDNServerManagerEndpointConfiguration;

import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;

/**
 * Camel {@link ApiCollection} for AS2
 */
public final class AS2ApiCollection extends ApiCollection<AS2ApiName, AS2Configuration> {

    private AS2ApiCollection() {
        final Map<String, String> aliases = new HashMap<>();
        final Map<AS2ApiName, ApiMethodHelper<? extends ApiMethod>> apiHelpers = new EnumMap<>(AS2ApiName.class);
        final Map<Class<? extends ApiMethod>, AS2ApiName> apiMethods = new HashMap<>();

        List<String> nullableArgs;

        aliases.clear();
        nullableArgs = Arrays.asList("ediMessageTransferEncoding", "signingAlgorithm", "signingCertificateChain", "signingPrivateKey", "compressionAlgorithm", "dispositionNotificationTo", "signedReceiptMicAlgorithms", "encryptingAlgorithm", "encryptingCertificateChain", "attachedFileName", "receiptDeliveryOption");
        apiHelpers.put(AS2ApiName.CLIENT, new ApiMethodHelper<>(AS2ClientManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(AS2ClientManagerApiMethod.class, AS2ApiName.CLIENT);

        aliases.clear();
        nullableArgs = Arrays.asList();
        apiHelpers.put(AS2ApiName.SERVER, new ApiMethodHelper<>(AS2ServerManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(AS2ServerManagerApiMethod.class, AS2ApiName.SERVER);

        aliases.clear();
        nullableArgs = Arrays.asList();
        apiHelpers.put(AS2ApiName.RECEIPT, new ApiMethodHelper<>(AS2AsyncMDNServerManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(AS2AsyncMDNServerManagerApiMethod.class, AS2ApiName.RECEIPT);

        setApiHelpers(apiHelpers);
        setApiMethods(apiMethods);
    }

    public AS2Configuration getEndpointConfiguration(AS2ApiName apiName) {
        AS2Configuration result = null;
        switch (apiName) {
            case CLIENT:
                result = new AS2ClientManagerEndpointConfiguration();
                break;
            case SERVER:
                result = new AS2ServerManagerEndpointConfiguration();
                break;
            case RECEIPT:
                result = new AS2AsyncMDNServerManagerEndpointConfiguration();
                break;
        }
        return result;
    }

    public static AS2ApiCollection getCollection() {
        return AS2ApiCollectionHolder.INSTANCE;
    }

    private static final class AS2ApiCollectionHolder {
        private static final AS2ApiCollection INSTANCE = new AS2ApiCollection();
    }
}
