/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.IntegrationPlatformSpec;
import org.apache.camel.v1.integrationplatformspec.Build;
import org.apache.camel.v1.integrationplatformspec.BuildBuilder;
import org.apache.camel.v1.integrationplatformspec.BuildFluent;
import org.apache.camel.v1.integrationplatformspec.Configuration;
import org.apache.camel.v1.integrationplatformspec.ConfigurationBuilder;
import org.apache.camel.v1.integrationplatformspec.ConfigurationFluent;
import org.apache.camel.v1.integrationplatformspec.Kamelet;
import org.apache.camel.v1.integrationplatformspec.KameletBuilder;
import org.apache.camel.v1.integrationplatformspec.KameletFluent;
import org.apache.camel.v1.integrationplatformspec.Traits;
import org.apache.camel.v1.integrationplatformspec.TraitsBuilder;
import org.apache.camel.v1.integrationplatformspec.TraitsFluent;

public class IntegrationPlatformSpecFluent<A extends IntegrationPlatformSpecFluent<A>>
extends BaseFluent<A> {
    private BuildBuilder build;
    private String cluster;
    private ArrayList<ConfigurationBuilder> configuration;
    private KameletBuilder kamelet;
    private String profile;
    private TraitsBuilder traits;

    public IntegrationPlatformSpecFluent() {
    }

    public IntegrationPlatformSpecFluent(IntegrationPlatformSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IntegrationPlatformSpec instance) {
        IntegrationPlatformSpec integrationPlatformSpec = instance = instance != null ? instance : new IntegrationPlatformSpec();
        if (instance != null) {
            this.withBuild(instance.getBuild());
            this.withCluster(instance.getCluster());
            this.withConfiguration(instance.getConfiguration());
            this.withKamelet(instance.getKamelet());
            this.withProfile(instance.getProfile());
            this.withTraits(instance.getTraits());
        }
    }

    public Build buildBuild() {
        return this.build != null ? this.build.build() : null;
    }

    public A withBuild(Build build) {
        this._visitables.remove((Object)"build");
        if (build != null) {
            this.build = new BuildBuilder(build);
            this._visitables.get((Object)"build").add(this.build);
        } else {
            this.build = null;
            this._visitables.get((Object)"build").remove((Object)this.build);
        }
        return (A)((Object)this);
    }

    public boolean hasBuild() {
        return this.build != null;
    }

    public BuildNested<A> withNewBuild() {
        return new BuildNested(null);
    }

    public BuildNested<A> withNewBuildLike(Build item) {
        return new BuildNested(item);
    }

    public BuildNested<A> editIntegrationplatformspecBuild() {
        return this.withNewBuildLike(Optional.ofNullable(this.buildBuild()).orElse(null));
    }

    public BuildNested<A> editOrNewBuild() {
        return this.withNewBuildLike(Optional.ofNullable(this.buildBuild()).orElse(new BuildBuilder().build()));
    }

    public BuildNested<A> editOrNewBuildLike(Build item) {
        return this.withNewBuildLike(Optional.ofNullable(this.buildBuild()).orElse(item));
    }

    public String getCluster() {
        return this.cluster;
    }

    public A withCluster(String cluster) {
        this.cluster = cluster;
        return (A)((Object)this);
    }

    public boolean hasCluster() {
        return this.cluster != null;
    }

    public A addToConfiguration(int index, Configuration item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        ConfigurationBuilder builder = new ConfigurationBuilder(item);
        if (index < 0 || index >= this.configuration.size()) {
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        } else {
            this._visitables.get((Object)"configuration").add(index, builder);
            this.configuration.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConfiguration(int index, Configuration item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        ConfigurationBuilder builder = new ConfigurationBuilder(item);
        if (index < 0 || index >= this.configuration.size()) {
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        } else {
            this._visitables.get((Object)"configuration").set(index, builder);
            this.configuration.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConfiguration(Configuration ... items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConfiguration(Collection<Configuration> items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConfiguration(Configuration ... items) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").remove((Object)builder);
            this.configuration.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConfiguration(Collection<Configuration> items) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").remove((Object)builder);
            this.configuration.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConfiguration(Predicate<ConfigurationBuilder> predicate) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        Iterator<ConfigurationBuilder> each = this.configuration.iterator();
        List visitables = this._visitables.get((Object)"configuration");
        while (each.hasNext()) {
            ConfigurationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Configuration> buildConfiguration() {
        return this.configuration != null ? IntegrationPlatformSpecFluent.build(this.configuration) : null;
    }

    public Configuration buildConfiguration(int index) {
        return this.configuration.get(index).build();
    }

    public Configuration buildFirstConfiguration() {
        return this.configuration.get(0).build();
    }

    public Configuration buildLastConfiguration() {
        return this.configuration.get(this.configuration.size() - 1).build();
    }

    public Configuration buildMatchingConfiguration(Predicate<ConfigurationBuilder> predicate) {
        for (ConfigurationBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConfiguration(Predicate<ConfigurationBuilder> predicate) {
        for (ConfigurationBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConfiguration(List<Configuration> configuration) {
        if (this.configuration != null) {
            this._visitables.get((Object)"configuration").clear();
        }
        if (configuration != null) {
            this.configuration = new ArrayList();
            for (Configuration item : configuration) {
                this.addToConfiguration(item);
            }
        } else {
            this.configuration = null;
        }
        return (A)((Object)this);
    }

    public A withConfiguration(Configuration ... configuration) {
        if (this.configuration != null) {
            this.configuration.clear();
            this._visitables.remove((Object)"configuration");
        }
        if (configuration != null) {
            for (Configuration item : configuration) {
                this.addToConfiguration(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null && !this.configuration.isEmpty();
    }

    public ConfigurationNested<A> addNewConfiguration() {
        return new ConfigurationNested(-1, null);
    }

    public ConfigurationNested<A> addNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(-1, item);
    }

    public ConfigurationNested<A> setNewConfigurationLike(int index, Configuration item) {
        return new ConfigurationNested(index, item);
    }

    public ConfigurationNested<A> editConfiguration(int index) {
        if (this.configuration.size() <= index) {
            throw new RuntimeException("Can't edit configuration. Index exceeds size.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public ConfigurationNested<A> editFirstConfiguration() {
        if (this.configuration.size() == 0) {
            throw new RuntimeException("Can't edit first configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(0, this.buildConfiguration(0));
    }

    public ConfigurationNested<A> editLastConfiguration() {
        int index = this.configuration.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configuration.size(); ++i) {
            if (!predicate.test(this.configuration.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configuration. No match found.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public Kamelet buildKamelet() {
        return this.kamelet != null ? this.kamelet.build() : null;
    }

    public A withKamelet(Kamelet kamelet) {
        this._visitables.remove((Object)"kamelet");
        if (kamelet != null) {
            this.kamelet = new KameletBuilder(kamelet);
            this._visitables.get((Object)"kamelet").add(this.kamelet);
        } else {
            this.kamelet = null;
            this._visitables.get((Object)"kamelet").remove((Object)this.kamelet);
        }
        return (A)((Object)this);
    }

    public boolean hasKamelet() {
        return this.kamelet != null;
    }

    public KameletNested<A> withNewKamelet() {
        return new KameletNested(null);
    }

    public KameletNested<A> withNewKameletLike(Kamelet item) {
        return new KameletNested(item);
    }

    public KameletNested<A> editIntegrationplatformspecKamelet() {
        return this.withNewKameletLike(Optional.ofNullable(this.buildKamelet()).orElse(null));
    }

    public KameletNested<A> editOrNewKamelet() {
        return this.withNewKameletLike(Optional.ofNullable(this.buildKamelet()).orElse(new KameletBuilder().build()));
    }

    public KameletNested<A> editOrNewKameletLike(Kamelet item) {
        return this.withNewKameletLike(Optional.ofNullable(this.buildKamelet()).orElse(item));
    }

    public String getProfile() {
        return this.profile;
    }

    public A withProfile(String profile) {
        this.profile = profile;
        return (A)((Object)this);
    }

    public boolean hasProfile() {
        return this.profile != null;
    }

    public Traits buildTraits() {
        return this.traits != null ? this.traits.build() : null;
    }

    public A withTraits(Traits traits) {
        this._visitables.remove((Object)"traits");
        if (traits != null) {
            this.traits = new TraitsBuilder(traits);
            this._visitables.get((Object)"traits").add(this.traits);
        } else {
            this.traits = null;
            this._visitables.get((Object)"traits").remove((Object)this.traits);
        }
        return (A)((Object)this);
    }

    public boolean hasTraits() {
        return this.traits != null;
    }

    public TraitsNested<A> withNewTraits() {
        return new TraitsNested(null);
    }

    public TraitsNested<A> withNewTraitsLike(Traits item) {
        return new TraitsNested(item);
    }

    public TraitsNested<A> editIntegrationplatformspecTraits() {
        return this.withNewTraitsLike(Optional.ofNullable(this.buildTraits()).orElse(null));
    }

    public TraitsNested<A> editOrNewTraits() {
        return this.withNewTraitsLike(Optional.ofNullable(this.buildTraits()).orElse(new TraitsBuilder().build()));
    }

    public TraitsNested<A> editOrNewTraitsLike(Traits item) {
        return this.withNewTraitsLike(Optional.ofNullable(this.buildTraits()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegrationPlatformSpecFluent that = (IntegrationPlatformSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.build, (Object)that.build)) {
            return false;
        }
        if (!Objects.equals(this.cluster, that.cluster)) {
            return false;
        }
        if (!Objects.equals(this.configuration, that.configuration)) {
            return false;
        }
        if (!Objects.equals((Object)this.kamelet, (Object)that.kamelet)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        return Objects.equals((Object)this.traits, (Object)that.traits);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.build, this.cluster, this.configuration, this.kamelet, this.profile, this.traits, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.build != null) {
            sb.append("build:");
            sb.append(this.build + ",");
        }
        if (this.cluster != null) {
            sb.append("cluster:");
            sb.append(this.cluster + ",");
        }
        if (this.configuration != null && !this.configuration.isEmpty()) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.kamelet != null) {
            sb.append("kamelet:");
            sb.append(this.kamelet + ",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile + ",");
        }
        if (this.traits != null) {
            sb.append("traits:");
            sb.append((Object)this.traits);
        }
        sb.append("}");
        return sb.toString();
    }

    public class BuildNested<N>
    extends BuildFluent<BuildNested<N>>
    implements Nested<N> {
        BuildBuilder builder;

        BuildNested(Build item) {
            this.builder = new BuildBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationPlatformSpecFluent.this.withBuild(this.builder.build());
        }

        public N endIntegrationplatformspecBuild() {
            return this.and();
        }
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;
        int index;

        ConfigurationNested(int index, Configuration item) {
            this.index = index;
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationPlatformSpecFluent.this.setToConfiguration(this.index, this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }

    public class KameletNested<N>
    extends KameletFluent<KameletNested<N>>
    implements Nested<N> {
        KameletBuilder builder;

        KameletNested(Kamelet item) {
            this.builder = new KameletBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationPlatformSpecFluent.this.withKamelet(this.builder.build());
        }

        public N endIntegrationplatformspecKamelet() {
            return this.and();
        }
    }

    public class TraitsNested<N>
    extends TraitsFluent<TraitsNested<N>>
    implements Nested<N> {
        TraitsBuilder builder;

        TraitsNested(Traits item) {
            this.builder = new TraitsBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationPlatformSpecFluent.this.withTraits(this.builder.build());
        }

        public N endIntegrationplatformspecTraits() {
            return this.and();
        }
    }
}

