/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.volumes;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.volumes.ScaleIO;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.volumes.scaleio.SecretRef;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.volumes.scaleio.SecretRefBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.volumes.scaleio.SecretRefFluent;

public class ScaleIOFluent<A extends ScaleIOFluent<A>>
extends BaseFluent<A> {
    private String fsType;
    private String gateway;
    private String protectionDomain;
    private Boolean readOnly;
    private SecretRefBuilder secretRef;
    private Boolean sslEnabled;
    private String storageMode;
    private String storagePool;
    private String system;
    private String volumeName;

    public ScaleIOFluent() {
    }

    public ScaleIOFluent(ScaleIO instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ScaleIO instance) {
        ScaleIO scaleIO = instance = instance != null ? instance : new ScaleIO();
        if (instance != null) {
            this.withFsType(instance.getFsType());
            this.withGateway(instance.getGateway());
            this.withProtectionDomain(instance.getProtectionDomain());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretRef(instance.getSecretRef());
            this.withSslEnabled(instance.getSslEnabled());
            this.withStorageMode(instance.getStorageMode());
            this.withStoragePool(instance.getStoragePool());
            this.withSystem(instance.getSystem());
            this.withVolumeName(instance.getVolumeName());
        }
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)((Object)this);
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public String getGateway() {
        return this.gateway;
    }

    public A withGateway(String gateway) {
        this.gateway = gateway;
        return (A)((Object)this);
    }

    public boolean hasGateway() {
        return this.gateway != null;
    }

    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    public A withProtectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
        return (A)((Object)this);
    }

    public boolean hasProtectionDomain() {
        return this.protectionDomain != null;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)((Object)this);
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public SecretRef buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(SecretRef secretRef) {
        this._visitables.remove((Object)"secretRef");
        if (secretRef != null) {
            this.secretRef = new SecretRefBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(SecretRef item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editScaleioSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new SecretRefBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(SecretRef item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public A withSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return (A)((Object)this);
    }

    public boolean hasSslEnabled() {
        return this.sslEnabled != null;
    }

    public String getStorageMode() {
        return this.storageMode;
    }

    public A withStorageMode(String storageMode) {
        this.storageMode = storageMode;
        return (A)((Object)this);
    }

    public boolean hasStorageMode() {
        return this.storageMode != null;
    }

    public String getStoragePool() {
        return this.storagePool;
    }

    public A withStoragePool(String storagePool) {
        this.storagePool = storagePool;
        return (A)((Object)this);
    }

    public boolean hasStoragePool() {
        return this.storagePool != null;
    }

    public String getSystem() {
        return this.system;
    }

    public A withSystem(String system) {
        this.system = system;
        return (A)((Object)this);
    }

    public boolean hasSystem() {
        return this.system != null;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)((Object)this);
    }

    public boolean hasVolumeName() {
        return this.volumeName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleIOFluent that = (ScaleIOFluent)((Object)o);
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.gateway, that.gateway)) {
            return false;
        }
        if (!Objects.equals(this.protectionDomain, that.protectionDomain)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals((Object)this.secretRef, (Object)that.secretRef)) {
            return false;
        }
        if (!Objects.equals(this.sslEnabled, that.sslEnabled)) {
            return false;
        }
        if (!Objects.equals(this.storageMode, that.storageMode)) {
            return false;
        }
        if (!Objects.equals(this.storagePool, that.storagePool)) {
            return false;
        }
        if (!Objects.equals(this.system, that.system)) {
            return false;
        }
        return Objects.equals(this.volumeName, that.volumeName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fsType, this.gateway, this.protectionDomain, this.readOnly, this.secretRef, this.sslEnabled, this.storageMode, this.storagePool, this.system, this.volumeName, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.gateway != null) {
            sb.append("gateway:");
            sb.append(this.gateway + ",");
        }
        if (this.protectionDomain != null) {
            sb.append("protectionDomain:");
            sb.append(this.protectionDomain + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.sslEnabled != null) {
            sb.append("sslEnabled:");
            sb.append(this.sslEnabled + ",");
        }
        if (this.storageMode != null) {
            sb.append("storageMode:");
            sb.append(this.storageMode + ",");
        }
        if (this.storagePool != null) {
            sb.append("storagePool:");
            sb.append(this.storagePool + ",");
        }
        if (this.system != null) {
            sb.append("system:");
            sb.append(this.system + ",");
        }
        if (this.volumeName != null) {
            sb.append("volumeName:");
            sb.append(this.volumeName);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public A withSslEnabled() {
        return this.withSslEnabled(true);
    }

    public class SecretRefNested<N>
    extends SecretRefFluent<SecretRefNested<N>>
    implements Nested<N> {
        SecretRefBuilder builder;

        SecretRefNested(SecretRef item) {
            this.builder = new SecretRefBuilder(this, item);
        }

        public N and() {
            return (N)ScaleIOFluent.this.withSecretRef(this.builder.build());
        }

        public N endScaleioSecretRef() {
            return this.and();
        }
    }
}

