/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CamelSchemeApplyConfiguration represents an declarative configuration of the CamelScheme type for use
// with apply.
type CamelSchemeApplyConfiguration struct {
	ID       *string                             `json:"id,omitempty"`
	Passive  *bool                               `json:"passive,omitempty"`
	HTTP     *bool                               `json:"http,omitempty"`
	Consumer *CamelSchemeScopeApplyConfiguration `json:"consumer,omitempty"`
	Producer *CamelSchemeScopeApplyConfiguration `json:"producer,omitempty"`
}

// CamelSchemeApplyConfiguration constructs an declarative configuration of the CamelScheme type for use with
// apply.
func CamelScheme() *CamelSchemeApplyConfiguration {
	return &CamelSchemeApplyConfiguration{}
}

// WithID sets the ID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ID field is set to the value of the last call.
func (b *CamelSchemeApplyConfiguration) WithID(value string) *CamelSchemeApplyConfiguration {
	b.ID = &value
	return b
}

// WithPassive sets the Passive field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Passive field is set to the value of the last call.
func (b *CamelSchemeApplyConfiguration) WithPassive(value bool) *CamelSchemeApplyConfiguration {
	b.Passive = &value
	return b
}

// WithHTTP sets the HTTP field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HTTP field is set to the value of the last call.
func (b *CamelSchemeApplyConfiguration) WithHTTP(value bool) *CamelSchemeApplyConfiguration {
	b.HTTP = &value
	return b
}

// WithConsumer sets the Consumer field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Consumer field is set to the value of the last call.
func (b *CamelSchemeApplyConfiguration) WithConsumer(value *CamelSchemeScopeApplyConfiguration) *CamelSchemeApplyConfiguration {
	b.Consumer = value
	return b
}

// WithProducer sets the Producer field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Producer field is set to the value of the last call.
func (b *CamelSchemeApplyConfiguration) WithProducer(value *CamelSchemeScopeApplyConfiguration) *CamelSchemeApplyConfiguration {
	b.Producer = value
	return b
}
