/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// S2iTaskApplyConfiguration represents an declarative configuration of the S2iTask type for use
// with apply.
type S2iTaskApplyConfiguration struct {
	BaseTaskApplyConfiguration `json:",inline"`
	ContextDir                 *string `json:"contextDir,omitempty"`
	Tag                        *string `json:"tag,omitempty"`
}

// S2iTaskApplyConfiguration constructs an declarative configuration of the S2iTask type for use with
// apply.
func S2iTask() *S2iTaskApplyConfiguration {
	return &S2iTaskApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *S2iTaskApplyConfiguration) WithName(value string) *S2iTaskApplyConfiguration {
	b.Name = &value
	return b
}

// WithConfiguration sets the Configuration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Configuration field is set to the value of the last call.
func (b *S2iTaskApplyConfiguration) WithConfiguration(value *BuildConfigurationApplyConfiguration) *S2iTaskApplyConfiguration {
	b.Configuration = value
	return b
}

// WithContextDir sets the ContextDir field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ContextDir field is set to the value of the last call.
func (b *S2iTaskApplyConfiguration) WithContextDir(value string) *S2iTaskApplyConfiguration {
	b.ContextDir = &value
	return b
}

// WithTag sets the Tag field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Tag field is set to the value of the last call.
func (b *S2iTaskApplyConfiguration) WithTag(value string) *S2iTaskApplyConfiguration {
	b.Tag = &value
	return b
}
