/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.UnsafeCloseable;
import org.jetbrains.annotations.NotNull;

public class UncheckedLongReference
extends UnsafeCloseable
implements LongReference,
ReferenceOwner {
    private BytesStore bytes;

    @NotNull
    public static LongReference create(BytesStore bytesStore, long offset, int size) {
        @NotNull LongReference ref = Jvm.isDebug() ? new BinaryLongReference() : new UncheckedLongReference();
        ref.bytesStore(bytesStore, offset, size);
        return ref;
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        this.throwExceptionIfClosedInSetter();
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        if (this.bytes != bytes) {
            if (this.bytes != null) {
                this.bytes.release(this);
            }
            this.bytes = bytes;
            bytes.reserve(this);
        }
        this.address(bytes.addressForRead(offset));
    }

    @NotNull
    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.address;
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @NotNull
    public String toString() {
        return this.address == 0L ? "addressForRead is 0" : "value: " + this.getValue();
    }

    public long getValue() {
        return this.getLong();
    }

    public void setValue(long value) {
        this.setLong(value);
    }

    public long getVolatileValue() {
        return this.getVolatileLong();
    }

    public void setVolatileValue(long value) {
        this.setVolatileLong(value);
    }

    public long getVolatileValue(long closedValue) {
        return this.getVolatileLong(closedValue);
    }

    public void setOrderedValue(long value) {
        this.setOrderedLong(value);
    }

    public long addValue(long delta) {
        return this.addLong(delta);
    }

    public long addAtomicValue(long delta) {
        return this.addAtomicLong(delta);
    }

    public boolean compareAndSwapValue(long expected, long value) {
        return this.compareAndSwapLong(expected, value);
    }

    protected void performClose() {
        if (this.bytes != null) {
            this.bytes.release(this);
        }
        this.bytes = null;
        super.performClose();
    }
}

