/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.wire.MicroTimestampLongConverter;

public class WatermarkedMicroTimestampLongConverter
extends MicroTimestampLongConverter {
    @Override
    public long parse(CharSequence text) {
        char digit;
        char letter = text.charAt(0);
        if (('A' <= letter && letter <= 'Z' || 'a' <= letter && letter <= 'z') && '0' <= (digit = text.charAt(1)) && digit <= '9') {
            long watermark = (long)(((letter & 0x31) - 1) * 10 + digit) << -8;
            long parse = super.parse(text.subSequence(2, text.length()));
            return parse | watermark;
        }
        throw new IllegalArgumentException("Unknown watermark");
    }

    @Override
    public void append(StringBuilder text, long value) {
        long time = value & 0xFF00000000000000L;
        long watermark = value >>> -8;
        text.append((char)(65L + watermark / 10L));
        text.append(watermark % 10L);
        super.append(text, time);
    }
}

