/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.utils.FBUtilities;
import org.mindrot.jbcrypt.BCrypt;

public class RoleOptions {
    private final Map<IRoleManager.Option, Object> options = new HashMap<IRoleManager.Option, Object>();

    public void setOption(IRoleManager.Option option, Object value) {
        if (this.options.containsKey((Object)option)) {
            throw new SyntaxException(String.format("Multiple definition for property '%s'", option.name()));
        }
        this.options.put(option, value);
    }

    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    public Map<IRoleManager.Option, Object> getOptions() {
        return this.options;
    }

    public Optional<Boolean> getSuperuser() {
        return Optional.ofNullable((Boolean)this.options.get((Object)IRoleManager.Option.SUPERUSER));
    }

    public Optional<Boolean> getLogin() {
        return Optional.ofNullable((Boolean)this.options.get((Object)IRoleManager.Option.LOGIN));
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable((String)this.options.get((Object)IRoleManager.Option.PASSWORD));
    }

    public Optional<String> getHashedPassword() {
        return Optional.ofNullable((String)this.options.get((Object)IRoleManager.Option.HASHED_PASSWORD));
    }

    public Optional<Map<String, String>> getCustomOptions() {
        return Optional.ofNullable((Map)this.options.get((Object)IRoleManager.Option.OPTIONS));
    }

    public void validate() {
        for (Map.Entry<IRoleManager.Option, Object> option : this.options.entrySet()) {
            if (!DatabaseDescriptor.getRoleManager().supportedOptions().contains((Object)option.getKey())) {
                throw new InvalidRequestException(String.format("%s doesn't support %s", new Object[]{DatabaseDescriptor.getRoleManager().getClass().getName(), option.getKey()}));
            }
            switch (option.getKey()) {
                case LOGIN: 
                case SUPERUSER: {
                    if (option.getValue() instanceof Boolean) break;
                    throw new InvalidRequestException(String.format("Invalid value for property '%s'. It must be a boolean", new Object[]{option.getKey()}));
                }
                case PASSWORD: {
                    if (!(option.getValue() instanceof String)) {
                        throw new InvalidRequestException(String.format("Invalid value for property '%s'. It must be a string", new Object[]{option.getKey()}));
                    }
                    if (!this.options.containsKey((Object)IRoleManager.Option.HASHED_PASSWORD)) break;
                    throw new InvalidRequestException(String.format("Properties '%s' and '%s' are mutually exclusive", new Object[]{IRoleManager.Option.PASSWORD, IRoleManager.Option.HASHED_PASSWORD}));
                }
                case HASHED_PASSWORD: {
                    if (!(option.getValue() instanceof String)) {
                        throw new InvalidRequestException(String.format("Invalid value for property '%s'. It must be a string", new Object[]{option.getKey()}));
                    }
                    if (this.options.containsKey((Object)IRoleManager.Option.PASSWORD)) {
                        throw new InvalidRequestException(String.format("Properties '%s' and '%s' are mutually exclusive", new Object[]{IRoleManager.Option.PASSWORD, IRoleManager.Option.HASHED_PASSWORD}));
                    }
                    try {
                        BCrypt.checkpw((String)"dummy", (String)((String)option.getValue()));
                        break;
                    }
                    catch (Exception e) {
                        throw new InvalidRequestException("Invalid hashed password value. Please use jBcrypt.");
                    }
                }
                case OPTIONS: {
                    if (option.getValue() instanceof Map) break;
                    throw new InvalidRequestException(String.format("Invalid value for property '%s'. It must be a map", new Object[]{option.getKey()}));
                }
            }
        }
    }

    public String toString() {
        return FBUtilities.toString(this.options);
    }
}

