/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class UseStatement
extends CQLStatement.Raw
implements CQLStatement {
    private final String keyspace;

    public UseStatement(String keyspace) {
        this.keyspace = keyspace;
    }

    @Override
    public UseStatement prepare(ClientState state) {
        return this;
    }

    @Override
    public void authorize(ClientState state) throws UnauthorizedException {
        state.validateLogin();
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        RequestValidations.checkTrue(DatabaseDescriptor.getUseStatementsEnabled(), "USE statements prohibited. (see use_statements_enabled in cassandra.yaml)");
    }

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options, Dispatcher.RequestTime requestTime) throws InvalidRequestException {
        QueryProcessor.metrics.useStatementsExecuted.inc();
        state.getClientState().setKeyspace(this.keyspace);
        return new ResultMessage.SetKeyspace(this.keyspace);
    }

    @Override
    public ResultMessage executeLocally(QueryState state, QueryOptions options) throws InvalidRequestException {
        return this.execute(state, options, Dispatcher.RequestTime.forImmediateExecution());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.USE_KEYSPACE, this.keyspace);
    }

    public String keyspace() {
        return this.keyspace;
    }
}

