/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.db.BufferClusteringBound;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.utils.memory.ByteBufferCloner;

public interface ClusteringBound<V>
extends ClusteringBoundOrBoundary<V> {
    public static final ClusteringBound<?> BOTTOM = new BufferClusteringBound(ClusteringPrefix.Kind.INCL_START_BOUND, BufferClusteringBound.EMPTY_VALUES_ARRAY);
    public static final ClusteringBound<?> TOP = new BufferClusteringBound(ClusteringPrefix.Kind.INCL_END_BOUND, BufferClusteringBound.EMPTY_VALUES_ARRAY);

    public static ClusteringPrefix.Kind boundKind(boolean isStart, boolean isInclusive) {
        return isStart ? (isInclusive ? ClusteringPrefix.Kind.INCL_START_BOUND : ClusteringPrefix.Kind.EXCL_START_BOUND) : (isInclusive ? ClusteringPrefix.Kind.INCL_END_BOUND : ClusteringPrefix.Kind.EXCL_END_BOUND);
    }

    @Override
    public ClusteringBound<V> invert();

    public ClusteringBound<ByteBuffer> clone(ByteBufferCloner var1);

    default public boolean isStart() {
        return this.kind().isStart();
    }

    default public boolean isEnd() {
        return !this.isStart();
    }

    default public boolean isInclusive() {
        return this.kind() == ClusteringPrefix.Kind.INCL_START_BOUND || this.kind() == ClusteringPrefix.Kind.INCL_END_BOUND;
    }

    default public boolean isExclusive() {
        return this.kind() == ClusteringPrefix.Kind.EXCL_START_BOUND || this.kind() == ClusteringPrefix.Kind.EXCL_END_BOUND;
    }

    default public int compareTo(ClusteringComparator comparator, List<ByteBuffer> sstableBound) {
        for (int i = 0; i < sstableBound.size(); ++i) {
            if (i >= this.size()) {
                return this.isStart() ? -1 : 1;
            }
            int cmp = comparator.compareComponent(i, this.get(i), this.accessor(), sstableBound.get(i), ByteBufferAccessor.instance);
            if (cmp == 0) continue;
            return cmp;
        }
        if (this.size() > sstableBound.size()) {
            return this.isStart() ? -1 : 1;
        }
        return this.isInclusive() ? 0 : (this.isStart() ? 1 : -1);
    }

    public static <V> ClusteringBound<V> create(ClusteringPrefix.Kind kind, ClusteringPrefix<V> from) {
        return from.accessor().factory().bound(kind, from.getRawValues());
    }

    public static ClusteringBound<?> inclusiveStartOf(ClusteringPrefix<?> from) {
        return ClusteringBound.create(ClusteringPrefix.Kind.INCL_START_BOUND, from);
    }

    public static ClusteringBound<?> inclusiveEndOf(ClusteringPrefix<?> from) {
        return ClusteringBound.create(ClusteringPrefix.Kind.INCL_END_BOUND, from);
    }

    public static ClusteringBound<?> exclusiveStartOf(ClusteringPrefix<?> from) {
        return ClusteringBound.create(ClusteringPrefix.Kind.EXCL_START_BOUND, from);
    }

    public static ClusteringBound<?> exclusiveEndOf(ClusteringPrefix<?> from) {
        return ClusteringBound.create(ClusteringPrefix.Kind.EXCL_END_BOUND, from);
    }

    public static ClusteringBound<?> create(ClusteringComparator comparator, boolean isStart, boolean isInclusive, Object ... values) {
        CBuilder builder = CBuilder.create(comparator);
        for (Object val : values) {
            if (val instanceof ByteBuffer) {
                builder.add((ByteBuffer)val);
                continue;
            }
            builder.add(val);
        }
        return builder.buildBound(isStart, isInclusive);
    }
}

