/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.RateLimiter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.ActiveCompactionsTracker;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.CompactionIterator;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.CompactionStrategyManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.compaction.writers.DefaultCompactionWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Refs;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTask
extends AbstractCompactionTask {
    protected static final Logger logger = LoggerFactory.getLogger(CompactionTask.class);
    protected final int gcBefore;
    protected final boolean keepOriginals;
    protected static long totalBytesCompacted = 0L;
    private ActiveCompactionsTracker activeCompactions;

    public CompactionTask(ColumnFamilyStore cfs, LifecycleTransaction txn, int gcBefore) {
        this(cfs, txn, gcBefore, false);
    }

    public CompactionTask(ColumnFamilyStore cfs, LifecycleTransaction txn, int gcBefore, boolean keepOriginals) {
        super(cfs, txn);
        this.gcBefore = gcBefore;
        this.keepOriginals = keepOriginals;
    }

    public static synchronized long addToTotalBytesCompacted(long bytesCompacted) {
        return totalBytesCompacted += bytesCompacted;
    }

    @Override
    protected int executeInternal(ActiveCompactionsTracker activeCompactions) {
        this.activeCompactions = activeCompactions == null ? ActiveCompactionsTracker.NOOP : activeCompactions;
        this.run();
        return this.transaction.originals().size();
    }

    public boolean reduceScopeForLimitedSpace(Set<SSTableReader> nonExpiredSSTables, long expectedSize) {
        if (this.partialCompactionsAcceptable() && this.transaction.originals().size() > 1) {
            SSTableReader removedSSTable = this.cfs.getMaxSizeFile(nonExpiredSSTables);
            logger.warn("insufficient space to compact all requested files. {}MiB required, {} for compaction {} - removing largest SSTable: {}", new Object[]{Float.valueOf((float)expectedSize / 1024.0f / 1024.0f), StringUtils.join(this.transaction.originals(), (String)", "), this.transaction.opId(), removedSSTable});
            this.transaction.cancel(removedSSTable);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runMayThrow() throws Exception {
        assert (this.transaction != null);
        if (this.transaction.originals().isEmpty()) {
            return;
        }
        CompactionStrategyManager strategy = this.cfs.getCompactionStrategyManager();
        if (DatabaseDescriptor.isSnapshotBeforeCompaction()) {
            Instant creationTime = FBUtilities.now();
            this.cfs.snapshotWithoutMemtable(creationTime.toEpochMilli() + "-compact-" + this.cfs.name, creationTime);
        }
        try (CompactionController controller = this.getCompactionController(this.transaction.originals());){
            long totalSourceCQLRows;
            long[] mergedRowCounts;
            Object newSStables;
            long timeSpentWritingKeys;
            long inputSizeBytes;
            Set<SSTableReader> fullyExpiredSSTables = controller.getFullyExpiredSSTables();
            if (!this.buildCompactionCandidatesForAvailableDiskSpace(fullyExpiredSSTables)) {
                controller.refreshOverlaps();
            }
            assert (!Iterables.any(this.transaction.originals(), (Predicate)new Predicate<SSTableReader>(){

                public boolean apply(SSTableReader sstable) {
                    return !sstable.descriptor.cfname.equals(CompactionTask.this.cfs.name);
                }
            }));
            TimeUUID taskId = this.transaction.opId();
            StringBuilder ssTableLoggerMsg = new StringBuilder("[");
            for (SSTableReader sstr : this.transaction.originals()) {
                ssTableLoggerMsg.append(String.format("%s:level=%d, ", sstr.getFilename(), sstr.getSSTableLevel()));
            }
            ssTableLoggerMsg.append("]");
            logger.info("Compacting ({}) {}", (Object)taskId, (Object)ssTableLoggerMsg);
            RateLimiter limiter = CompactionManager.instance.getRateLimiter();
            long start = Clock.Global.nanoTime();
            long startTime = Clock.Global.currentTimeMillis();
            long totalKeysWritten = 0L;
            long estimatedKeys = 0L;
            this.maybeNotifyIndexersAboutRowsInFullyExpiredSSTables(fullyExpiredSSTables);
            Sets.SetView actuallyCompact = Sets.difference(this.transaction.originals(), fullyExpiredSSTables);
            int nowInSec = FBUtilities.nowInSeconds();
            try (Refs refs = Refs.ref(actuallyCompact);
                 AbstractCompactionStrategy.ScannerList scanners = strategy.getScanners((Collection<SSTableReader>)actuallyCompact);
                 CompactionIterator ci = new CompactionIterator(this.compactionType, scanners.scanners, controller, nowInSec, taskId);){
                long lastCheckObsoletion = start;
                inputSizeBytes = scanners.getTotalCompressedSize();
                double compressionRatio = scanners.getCompressionRatio();
                if (compressionRatio == -1.0) {
                    compressionRatio = 1.0;
                }
                long lastBytesScanned = 0L;
                this.activeCompactions.beginCompaction(ci);
                try (CompactionAwareWriter writer = this.getCompactionAwareWriter(this.cfs, this.getDirectories(), this.transaction, (Set<SSTableReader>)actuallyCompact);){
                    if (!controller.cfs.getCompactionStrategyManager().isActive()) {
                        throw new CompactionInterruptedException(ci.getCompactionInfo());
                    }
                    estimatedKeys = writer.estimatedKeys();
                    while (ci.hasNext()) {
                        if (writer.append(ci.next())) {
                            ++totalKeysWritten;
                        }
                        long bytesScanned = scanners.getTotalBytesScanned();
                        CompactionManager.compactionRateLimiterAcquire(limiter, bytesScanned, lastBytesScanned, compressionRatio);
                        lastBytesScanned = bytesScanned;
                        if (Clock.Global.nanoTime() - lastCheckObsoletion <= TimeUnit.MINUTES.toNanos(1L)) continue;
                        controller.maybeRefreshOverlaps();
                        lastCheckObsoletion = Clock.Global.nanoTime();
                    }
                    timeSpentWritingKeys = TimeUnit.NANOSECONDS.toMillis(Clock.Global.nanoTime() - start);
                    newSStables = writer.finish();
                }
                finally {
                    this.activeCompactions.finishCompaction(ci);
                    mergedRowCounts = ci.getMergedRowCounts();
                    totalSourceCQLRows = ci.getTotalSourceCQLRows();
                }
            }
            if (this.transaction.isOffline()) {
                return;
            }
            long durationInNano = Clock.Global.nanoTime() - start;
            long dTime = TimeUnit.NANOSECONDS.toMillis(durationInNano);
            long startsize = inputSizeBytes;
            long endsize = SSTableReader.getTotalBytes((Iterable<SSTableReader>)newSStables);
            double ratio = (double)endsize / (double)startsize;
            StringBuilder newSSTableNames = new StringBuilder();
            Iterator iterator = newSStables.iterator();
            while (iterator.hasNext()) {
                SSTableReader reader = (SSTableReader)iterator.next();
                newSSTableNames.append(reader.descriptor.baseFilename()).append(",");
            }
            long totalSourceRows = 0L;
            for (int i = 0; i < mergedRowCounts.length; ++i) {
                totalSourceRows += mergedRowCounts[i] * (long)(i + 1);
            }
            String mergeSummary = CompactionTask.updateCompactionHistory(taskId, this.cfs.keyspace.getName(), this.cfs.getTableName(), mergedRowCounts, startsize, endsize);
            logger.info(String.format("Compacted (%s) %d sstables to [%s] to level=%d.  %s to %s (~%d%% of original) in %,dms.  Read Throughput = %s, Write Throughput = %s, Row Throughput = ~%,d/s.  %,d total partitions merged to %,d.  Partition merge counts were {%s}. Time spent writing keys = %,dms", taskId, this.transaction.originals().size(), newSSTableNames.toString(), this.getLevel(), FBUtilities.prettyPrintMemory(startsize), FBUtilities.prettyPrintMemory(endsize), (int)(ratio * 100.0), dTime, FBUtilities.prettyPrintMemoryPerSecond(startsize, durationInNano), FBUtilities.prettyPrintMemoryPerSecond(endsize, durationInNano), (long)((int)totalSourceCQLRows) / (TimeUnit.NANOSECONDS.toSeconds(durationInNano) + 1L), totalSourceRows, totalKeysWritten, mergeSummary, timeSpentWritingKeys));
            if (logger.isTraceEnabled()) {
                logger.trace("CF Total Bytes Compacted: {}", (Object)FBUtilities.prettyPrintMemory(CompactionTask.addToTotalBytesCompacted(endsize)));
                logger.trace("Actual #keys: {}, Estimated #keys:{}, Err%: {}", new Object[]{totalKeysWritten, estimatedKeys, (double)(totalKeysWritten - estimatedKeys) / (double)totalKeysWritten});
            }
            this.cfs.getCompactionStrategyManager().compactionLogger.compaction(startTime, this.transaction.originals(), Clock.Global.currentTimeMillis(), (Collection<SSTableReader>)newSStables);
            this.cfs.metric.compactionBytesWritten.inc(endsize);
        }
    }

    @Override
    public CompactionAwareWriter getCompactionAwareWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction transaction, Set<SSTableReader> nonExpiredSSTables) {
        return new DefaultCompactionWriter(cfs, directories, transaction, nonExpiredSSTables, this.keepOriginals, this.getLevel());
    }

    public static String updateCompactionHistory(TimeUUID taskId, String keyspaceName, String columnFamilyName, long[] mergedRowCounts, long startSize, long endSize) {
        StringBuilder mergeSummary = new StringBuilder(mergedRowCounts.length * 10);
        HashMap<Integer, Long> mergedRows = new HashMap<Integer, Long>();
        for (int i = 0; i < mergedRowCounts.length; ++i) {
            long count = mergedRowCounts[i];
            if (count == 0L) continue;
            int rows = i + 1;
            mergeSummary.append(String.format("%d:%d, ", rows, count));
            mergedRows.put(rows, count);
        }
        SystemKeyspace.updateCompactionHistory(taskId, keyspaceName, columnFamilyName, Clock.Global.currentTimeMillis(), startSize, endSize, mergedRows);
        return mergeSummary.toString();
    }

    protected Directories getDirectories() {
        return this.cfs.getDirectories();
    }

    public static long getMinRepairedAt(Set<SSTableReader> actuallyCompact) {
        long minRepairedAt = Long.MAX_VALUE;
        for (SSTableReader sstable : actuallyCompact) {
            minRepairedAt = Math.min(minRepairedAt, sstable.getSSTableMetadata().repairedAt);
        }
        if (minRepairedAt == Long.MAX_VALUE) {
            return 0L;
        }
        return minRepairedAt;
    }

    public static TimeUUID getPendingRepair(Set<SSTableReader> sstables) {
        if (sstables.isEmpty()) {
            return ActiveRepairService.NO_PENDING_REPAIR;
        }
        HashSet<TimeUUID> ids = new HashSet<TimeUUID>();
        for (SSTableReader sstable : sstables) {
            ids.add(sstable.getSSTableMetadata().pendingRepair);
        }
        if (ids.size() != 1) {
            throw new RuntimeException(String.format("Attempting to compact pending repair sstables with sstables from other repair, or sstables not pending repair: %s", ids));
        }
        return (TimeUUID)ids.iterator().next();
    }

    public static boolean getIsTransient(Set<SSTableReader> sstables) {
        if (sstables.isEmpty()) {
            return false;
        }
        boolean isTransient = sstables.iterator().next().isTransient();
        if (!Iterables.all(sstables, sstable -> sstable.isTransient() == isTransient)) {
            throw new RuntimeException("Attempting to compact transient sstables with non transient sstables");
        }
        return isTransient;
    }

    protected boolean buildCompactionCandidatesForAvailableDiskSpace(Set<SSTableReader> fullyExpiredSSTables) {
        if (!this.cfs.isCompactionDiskSpaceCheckEnabled() && this.compactionType == OperationType.COMPACTION) {
            logger.info("Compaction space check is disabled - trying to compact all sstables");
            return true;
        }
        Sets.SetView nonExpiredSSTables = Sets.difference(this.transaction.originals(), fullyExpiredSSTables);
        CompactionStrategyManager strategy = this.cfs.getCompactionStrategyManager();
        int sstablesRemoved = 0;
        while (!nonExpiredSSTables.isEmpty()) {
            long expectedWriteSize = this.cfs.getExpectedCompactedFileSize((Iterable<SSTableReader>)nonExpiredSSTables, this.compactionType);
            long estimatedSSTables = Math.max(1L, expectedWriteSize / strategy.getMaxSSTableBytes());
            if (this.cfs.getDirectories().hasAvailableDiskSpace(estimatedSSTables, expectedWriteSize)) break;
            if (!this.reduceScopeForLimitedSpace((Set<SSTableReader>)nonExpiredSSTables, expectedWriteSize)) {
                if (this.partialCompactionsAcceptable() && fullyExpiredSSTables.size() > 0) {
                    assert (this.transaction.originals().equals(fullyExpiredSSTables));
                    break;
                }
                String msg = String.format("Not enough space for compaction, estimated sstables = %d, expected write size = %d", estimatedSSTables, expectedWriteSize);
                logger.warn(msg);
                CompactionManager.instance.incrementAborted();
                throw new RuntimeException(msg);
            }
            ++sstablesRemoved;
            logger.warn("Not enough space for compaction, {}MiB estimated.  Reducing scope.", (Object)Float.valueOf((float)expectedWriteSize / 1024.0f / 1024.0f));
        }
        if (sstablesRemoved > 0) {
            CompactionManager.instance.incrementCompactionsReduced();
            CompactionManager.instance.incrementSstablesDropppedFromCompactions(sstablesRemoved);
            return false;
        }
        return true;
    }

    protected int getLevel() {
        return 0;
    }

    protected CompactionController getCompactionController(Set<SSTableReader> toCompact) {
        return new CompactionController(this.cfs, toCompact, this.gcBefore);
    }

    protected boolean partialCompactionsAcceptable() {
        return !this.isUserDefined;
    }

    public static long getMaxDataAge(Collection<SSTableReader> sstables) {
        long max = 0L;
        for (SSTableReader sstable : sstables) {
            if (sstable.maxDataAge <= max) continue;
            max = sstable.maxDataAge;
        }
        return max;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void maybeNotifyIndexersAboutRowsInFullyExpiredSSTables(Set<SSTableReader> fullyExpiredSSTables) {
        if (fullyExpiredSSTables.isEmpty()) {
            return;
        }
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (Index index : this.cfs.indexManager.listIndexes()) {
            if (!index.notifyIndexerAboutRowsInFullyExpiredSSTables()) continue;
            indexes.add(index);
        }
        if (indexes.isEmpty()) {
            return;
        }
        Iterator<Object> iterator = fullyExpiredSSTables.iterator();
        block27: while (iterator.hasNext()) {
            SSTableReader expiredSSTable = (SSTableReader)iterator.next();
            ISSTableScanner scanner = expiredSSTable.getScanner();
            Throwable throwable = null;
            try {
                while (true) {
                    UnfilteredRowIterator partition;
                    block43: {
                        if (!scanner.hasNext()) continue block27;
                        partition = (UnfilteredRowIterator)scanner.next();
                        Throwable throwable2 = null;
                        try {
                            try (WriteContext ctx = this.cfs.keyspace.getWriteHandler().createContextForIndexing();){
                                ArrayList<Index.Indexer> indexers = new ArrayList<Index.Indexer>();
                                for (int i = 0; i < indexes.size(); ++i) {
                                    Index.Indexer indexer = ((Index)indexes.get(i)).indexerFor(partition.partitionKey(), partition.columns(), FBUtilities.nowInSeconds(), ctx, IndexTransaction.Type.COMPACTION);
                                    if (indexer == null) continue;
                                    indexers.add(indexer);
                                }
                                if (!indexers.isEmpty()) {
                                    for (Index.Indexer indexer : indexers) {
                                        indexer.begin();
                                    }
                                    while (partition.hasNext()) {
                                        Unfiltered unfiltered = (Unfiltered)partition.next();
                                        if (!(unfiltered instanceof Row)) continue;
                                        for (Index.Indexer indexer : indexers) {
                                            indexer.removeRow((Row)unfiltered);
                                        }
                                    }
                                    for (Index.Indexer indexer : indexers) {
                                        indexer.finish();
                                    }
                                }
                            }
                            if (partition == null) continue;
                            if (throwable2 == null) break block43;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (partition == null) throw throwable4;
                                if (throwable2 != null) {
                                    try {
                                        partition.close();
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                }
                                partition.close();
                                throw throwable4;
                            }
                        }
                        try {
                            partition.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    partition.close();
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (scanner == null) continue;
                if (throwable != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    continue;
                }
                scanner.close();
            }
        }
    }
}

