/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.cassandra.diag.DiagnosticEvent;
import org.apache.cassandra.hints.HintsService;

final class HintsServiceEvent
extends DiagnosticEvent {
    private final HintsServiceEventType type;
    private final HintsService service;
    private final boolean isDispatchPaused;
    private final boolean isShutdown;
    private final boolean dispatchExecutorIsPaused;
    private final boolean dispatchExecutorHasScheduledDispatches;

    HintsServiceEvent(HintsServiceEventType type, HintsService service) {
        this.type = type;
        this.service = service;
        this.isDispatchPaused = service.isDispatchPaused.get();
        this.isShutdown = service.isShutDown();
        this.dispatchExecutorIsPaused = service.dispatchExecutor.isPaused();
        this.dispatchExecutorHasScheduledDispatches = service.dispatchExecutor.hasScheduledDispatches();
    }

    public Enum<HintsServiceEventType> getType() {
        return this.type;
    }

    public HashMap<String, Serializable> toMap() {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("isDispatchPaused", Boolean.valueOf(this.isDispatchPaused));
        ret.put("isShutdown", Boolean.valueOf(this.isShutdown));
        ret.put("dispatchExecutorIsPaused", Boolean.valueOf(this.dispatchExecutorIsPaused));
        ret.put("dispatchExecutorHasScheduledDispatches", Boolean.valueOf(this.dispatchExecutorHasScheduledDispatches));
        return ret;
    }

    static enum HintsServiceEventType {
        DISPATCHING_STARTED,
        DISPATCHING_PAUSED,
        DISPATCHING_RESUMED,
        DISPATCHING_SHUTDOWN;

    }
}

