/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.cassandra.index.sasi.utils.CombinedValue;
import org.apache.cassandra.index.sasi.utils.RangeIterator;
import org.apache.cassandra.io.util.FileUtils;

public class RangeUnionIterator<K extends Comparable<K>, D extends CombinedValue<K>>
extends RangeIterator<K, D> {
    private final PriorityQueue<RangeIterator<K, D>> ranges;

    private RangeUnionIterator(RangeIterator.Builder.Statistics<K, D> statistics, PriorityQueue<RangeIterator<K, D>> ranges) {
        super(statistics);
        this.ranges = ranges;
    }

    @Override
    public D computeNext() {
        RangeIterator<K, D> head = null;
        while (!this.ranges.isEmpty() && !(head = this.ranges.poll()).hasNext()) {
            FileUtils.closeQuietly(head);
        }
        if (head == null || !head.hasNext()) {
            return (D)((CombinedValue)this.endOfData());
        }
        CombinedValue candidate = (CombinedValue)head.next();
        ArrayList<RangeIterator<K, D>> processedRanges = new ArrayList<RangeIterator<K, D>>();
        if (head.hasNext()) {
            processedRanges.add(head);
        } else {
            FileUtils.closeQuietly(head);
        }
        while (!this.ranges.isEmpty()) {
            RangeIterator<K, D> range = this.ranges.peek();
            int cmp = ((Comparable)candidate.get()).compareTo(range.getCurrent());
            assert (cmp <= 0);
            if (cmp < 0) break;
            if (cmp != 0) continue;
            candidate.merge((CombinedValue)range.next());
            range = this.ranges.poll();
            if (range.hasNext()) {
                processedRanges.add(range);
                continue;
            }
            FileUtils.closeQuietly(range);
        }
        this.ranges.addAll(processedRanges);
        return (D)candidate;
    }

    @Override
    protected void performSkipTo(K nextToken) {
        ArrayList<RangeIterator<K, D>> changedRanges = new ArrayList<RangeIterator<K, D>>();
        while (!this.ranges.isEmpty() && this.ranges.peek().getCurrent().compareTo(nextToken) < 0) {
            RangeIterator<K, D> head = this.ranges.poll();
            if (head.getMaximum().compareTo(nextToken) >= 0) {
                head.skipTo(nextToken);
                changedRanges.add(head);
                continue;
            }
            FileUtils.closeQuietly(head);
        }
        this.ranges.addAll(changedRanges.stream().collect(Collectors.toList()));
    }

    @Override
    public void close() throws IOException {
        this.ranges.forEach((Consumer<RangeIterator<K, D>>)((Consumer<RangeIterator>)FileUtils::closeQuietly));
    }

    public static <K extends Comparable<K>, D extends CombinedValue<K>> Builder<K, D> builder() {
        return new Builder();
    }

    public static <K extends Comparable<K>, D extends CombinedValue<K>> RangeIterator<K, D> build(List<RangeIterator<K, D>> tokens) {
        return new Builder<K, D>().add(tokens).build();
    }

    public static class Builder<K extends Comparable<K>, D extends CombinedValue<K>>
    extends RangeIterator.Builder<K, D> {
        public Builder() {
            super(RangeIterator.Builder.IteratorType.UNION);
        }

        @Override
        protected RangeIterator<K, D> buildIterator() {
            switch (this.rangeCount()) {
                case 1: {
                    return (RangeIterator)this.ranges.poll();
                }
            }
            return new RangeUnionIterator(this.statistics, this.ranges);
        }
    }
}

