/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.cassandra.cache.ChunkCache;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.rows.PartitionSerializationException;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundaryMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexInfo;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.format.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.ChecksummedSequentialWriter;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileOutputStreamPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.io.util.SequentialWriterOption;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.BloomFilterSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;
import org.apache.cassandra.utils.concurrent.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigTableWriter
extends SSTableWriter {
    private static final Logger logger = LoggerFactory.getLogger(BigTableWriter.class);
    private final ColumnIndex columnIndexWriter;
    private final IndexWriter iwriter;
    private final FileHandle.Builder dbuilder;
    protected final SequentialWriter dataFile;
    private DecoratedKey lastWrittenKey;
    private DataPosition dataMark;
    private long lastEarlyOpenLength = 0L;
    private final Optional<ChunkCache> chunkCache = Optional.ofNullable(ChunkCache.instance);
    private final SequentialWriterOption writerOption = SequentialWriterOption.newBuilder().trickleFsync(DatabaseDescriptor.getTrickleFsync()).trickleFsyncByteInterval(DatabaseDescriptor.getTrickleFsyncIntervalInKiB() * 1024).build();

    public BigTableWriter(Descriptor descriptor, long keyCount, long repairedAt, TimeUUID pendingRepair, boolean isTransient, TableMetadataRef metadata, MetadataCollector metadataCollector, SerializationHeader header, Collection<SSTableFlushObserver> observers, LifecycleNewTracker lifecycleNewTracker) {
        super(descriptor, keyCount, repairedAt, pendingRepair, isTransient, metadata, metadataCollector, header, observers);
        lifecycleNewTracker.trackNew(this);
        if (this.compression) {
            CompressionParams compressionParams = this.compressionFor(lifecycleNewTracker.opType());
            this.dataFile = new CompressedSequentialWriter(new File(this.getFilename()), descriptor.filenameFor(Component.COMPRESSION_INFO), new File(descriptor.filenameFor(Component.DIGEST)), this.writerOption, compressionParams, metadataCollector);
        } else {
            this.dataFile = new ChecksummedSequentialWriter(new File(this.getFilename()), new File(descriptor.filenameFor(Component.CRC)), new File(descriptor.filenameFor(Component.DIGEST)), this.writerOption);
        }
        this.dbuilder = new FileHandle.Builder(descriptor.filenameFor(Component.DATA)).compressed(this.compression).mmapped(DatabaseDescriptor.getDiskAccessMode() == Config.DiskAccessMode.mmap);
        this.chunkCache.ifPresent(this.dbuilder::withChunkCache);
        this.iwriter = new IndexWriter(keyCount);
        this.columnIndexWriter = new ColumnIndex(this.header, this.dataFile, descriptor.version, this.observers, this.getRowIndexEntrySerializer().indexInfoSerializer());
    }

    private CompressionParams compressionFor(OperationType opType) {
        CompressionParams compressionParams = this.metadata.getLocal().params.compression;
        ICompressor compressor = compressionParams.getSstableCompressor();
        if (null != compressor && opType == OperationType.FLUSH) {
            switch (DatabaseDescriptor.getFlushCompression()) {
                case none: {
                    compressionParams = CompressionParams.NOOP;
                    break;
                }
                case fast: {
                    if (compressor.recommendedUses().contains((Object)ICompressor.Uses.FAST_COMPRESSION)) break;
                    compressionParams = CompressionParams.DEFAULT;
                    break;
                }
            }
        }
        return compressionParams;
    }

    @Override
    public void mark() {
        this.dataMark = this.dataFile.mark();
        this.iwriter.mark();
    }

    @Override
    public void resetAndTruncate() {
        this.dataFile.resetAndTruncate(this.dataMark);
        this.iwriter.resetAndTruncate();
    }

    protected long beforeAppend(DecoratedKey decoratedKey) {
        assert (decoratedKey != null) : "Keys must not be null";
        if (this.lastWrittenKey != null && this.lastWrittenKey.compareTo(decoratedKey) >= 0) {
            throw new RuntimeException("Last written key " + this.lastWrittenKey + " >= current key " + decoratedKey + " writing into " + this.getFilename());
        }
        return this.lastWrittenKey == null ? 0L : this.dataFile.position();
    }

    private void afterAppend(DecoratedKey decoratedKey, long dataEnd, RowIndexEntry index, ByteBuffer indexInfo) throws IOException {
        this.metadataCollector.addKey(decoratedKey.getKey());
        this.last = this.lastWrittenKey = decoratedKey;
        if (this.first == null) {
            this.first = this.lastWrittenKey;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("wrote {} at {}", (Object)decoratedKey, (Object)dataEnd);
        }
        this.iwriter.append(decoratedKey, index, dataEnd, indexInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RowIndexEntry append(UnfilteredRowIterator iterator) {
        DecoratedKey key = iterator.partitionKey();
        if (key.getKey().remaining() > 65535) {
            logger.error("Key size {} exceeds maximum of {}, skipping row", (Object)key.getKey().remaining(), (Object)65535);
            return null;
        }
        if (iterator.isEmpty()) {
            return null;
        }
        long startPosition = this.beforeAppend(key);
        this.observers.forEach(o -> o.startPartition(key, this.iwriter.indexFile.position()));
        this.columnIndexWriter.reset();
        try (UnfilteredRowIterator collecting = Transformation.apply(iterator, new StatsCollector(this.metadataCollector));){
            this.columnIndexWriter.buildRowIndex(collecting);
            long indexFilePosition = (long)ByteBufferUtil.serializedSizeWithShortLength(key.getKey()) + this.iwriter.indexFile.position();
            RowIndexEntry<IndexInfo> entry = RowIndexEntry.create(startPosition, indexFilePosition, collecting.partitionLevelDeletion(), this.columnIndexWriter.headerLength, this.columnIndexWriter.columnIndexCount, this.columnIndexWriter.indexInfoSerializedSize(), this.columnIndexWriter.indexSamples(), this.columnIndexWriter.offsets(), this.getRowIndexEntrySerializer().indexInfoSerializer());
            long endPosition = this.dataFile.position();
            long rowSize = endPosition - startPosition;
            this.maybeLogLargePartitionWarning(key, rowSize);
            this.maybeLogManyTombstonesWarning(key, this.metadataCollector.totalTombstones);
            this.metadataCollector.addPartitionSizeInBytes(rowSize);
            this.afterAppend(key, endPosition, entry, this.columnIndexWriter.buffer());
            RowIndexEntry<IndexInfo> rowIndexEntry = entry;
            return rowIndexEntry;
        }
        catch (BufferOverflowException boe) {
            throw new PartitionSerializationException(iterator, (Throwable)boe);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
    }

    private RowIndexEntry.IndexSerializer<IndexInfo> getRowIndexEntrySerializer() {
        return this.rowIndexEntrySerializer;
    }

    private void maybeLogLargePartitionWarning(DecoratedKey key, long rowSize) {
        if (rowSize > DatabaseDescriptor.getCompactionLargePartitionWarningThreshold()) {
            String keyString = this.metadata().partitionKeyType.getString(key.getKey());
            logger.warn("Writing large partition {}/{}:{} ({}) to sstable {}", new Object[]{this.metadata.keyspace, this.metadata.name, keyString, FBUtilities.prettyPrintMemory(rowSize), this.getFilename()});
        }
    }

    private void maybeLogManyTombstonesWarning(DecoratedKey key, int tombstoneCount) {
        if (tombstoneCount > DatabaseDescriptor.getCompactionTombstoneWarningThreshold()) {
            String keyString = this.metadata().partitionKeyType.getString(key.getKey());
            logger.warn("Writing {} tombstones to {}/{}:{} in sstable {}", new Object[]{tombstoneCount, this.metadata.keyspace, this.metadata.name, keyString, this.getFilename()});
        }
    }

    @Override
    public SSTableReader openEarly() {
        IndexSummaryBuilder.ReadableBoundary boundary = this.iwriter.getMaxReadable();
        if (boundary == null) {
            return null;
        }
        IndexSummary indexSummary = null;
        FileHandle ifile = null;
        FileHandle dfile = null;
        SSTableReader sstable = null;
        try {
            StatsMetadata stats = this.statsMetadata();
            assert (boundary.indexLength > 0L && boundary.dataLength > 0L);
            indexSummary = this.iwriter.summary.build(this.metadata().partitioner, boundary);
            long indexFileLength = new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)).length();
            int indexBufferSize = this.optimizationStrategy.bufferSize(indexFileLength / (long)indexSummary.size());
            ifile = this.iwriter.builder.bufferSize(indexBufferSize).complete(boundary.indexLength);
            if (this.compression) {
                this.dbuilder.withCompressionMetadata(((CompressedSequentialWriter)this.dataFile).open(boundary.dataLength));
            }
            int dataBufferSize = this.optimizationStrategy.bufferSize(stats.estimatedPartitionSize.percentile(DatabaseDescriptor.getDiskOptimizationEstimatePercentile()));
            dfile = this.dbuilder.bufferSize(dataBufferSize).complete(boundary.dataLength);
            this.invalidateCacheAtBoundary(dfile);
            sstable = SSTableReader.internalOpen(this.descriptor, this.components, this.metadata, ifile, dfile, indexSummary, this.iwriter.bf.sharedCopy(), this.maxDataAge, stats, SSTableReader.OpenReason.EARLY, this.header);
            sstable.first = BigTableWriter.getMinimalKey(this.first);
            sstable.last = BigTableWriter.getMinimalKey(boundary.lastKey);
            return sstable;
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
            if (sstable != null) {
                sstable.selfRef().release();
            } else {
                Stream.of(indexSummary, ifile, dfile).filter(Objects::nonNull).forEach(SharedCloseableImpl::close);
            }
            throw t;
        }
    }

    void invalidateCacheAtBoundary(FileHandle dfile) {
        this.chunkCache.ifPresent(cache -> {
            if (this.lastEarlyOpenLength != 0L && dfile.dataLength() > this.lastEarlyOpenLength) {
                cache.invalidatePosition(dfile, this.lastEarlyOpenLength);
            }
        });
        this.lastEarlyOpenLength = dfile.dataLength();
    }

    @Override
    public SSTableReader openFinalEarly() {
        this.dataFile.sync();
        this.iwriter.indexFile.sync();
        return this.openFinal(SSTableReader.OpenReason.EARLY);
    }

    private SSTableReader openFinal(SSTableReader.OpenReason openReason) {
        if (this.maxDataAge < 0L) {
            this.maxDataAge = Clock.Global.currentTimeMillis();
        }
        IndexSummary indexSummary = null;
        FileHandle ifile = null;
        FileHandle dfile = null;
        SSTableReader sstable = null;
        try {
            StatsMetadata stats = this.statsMetadata();
            indexSummary = this.iwriter.summary.build(this.metadata().partitioner);
            long indexFileLength = new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)).length();
            int dataBufferSize = this.optimizationStrategy.bufferSize(stats.estimatedPartitionSize.percentile(DatabaseDescriptor.getDiskOptimizationEstimatePercentile()));
            int indexBufferSize = this.optimizationStrategy.bufferSize(indexFileLength / (long)indexSummary.size());
            ifile = this.iwriter.builder.bufferSize(indexBufferSize).complete();
            if (this.compression) {
                this.dbuilder.withCompressionMetadata(((CompressedSequentialWriter)this.dataFile).open(0L));
            }
            dfile = this.dbuilder.bufferSize(dataBufferSize).complete();
            this.invalidateCacheAtBoundary(dfile);
            sstable = SSTableReader.internalOpen(this.descriptor, this.components, this.metadata, ifile, dfile, indexSummary, this.iwriter.bf.sharedCopy(), this.maxDataAge, stats, openReason, this.header);
            sstable.first = BigTableWriter.getMinimalKey(this.first);
            sstable.last = BigTableWriter.getMinimalKey(this.last);
            return sstable;
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
            if (sstable != null) {
                sstable.selfRef().release();
            } else {
                Stream.of(indexSummary, ifile, dfile).filter(Objects::nonNull).forEach(SharedCloseableImpl::close);
            }
            throw t;
        }
    }

    @Override
    protected SSTableWriter.TransactionalProxy txnProxy() {
        return new TransactionalProxy();
    }

    private void writeMetadata(Descriptor desc, Map<MetadataType, MetadataComponent> components) {
        File file = new File(desc.filenameFor(Component.STATS));
        try (SequentialWriter out = new SequentialWriter(file, this.writerOption);){
            desc.getMetadataSerializer().serialize(components, out, desc.version);
            out.finish();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, file.path());
        }
    }

    @Override
    public long getFilePointer() {
        return this.dataFile.position();
    }

    @Override
    public long getOnDiskFilePointer() {
        return this.dataFile.getOnDiskFilePointer();
    }

    @Override
    public long getEstimatedOnDiskBytesWritten() {
        return this.dataFile.getEstimatedOnDiskBytesWritten();
    }

    class IndexWriter
    extends Transactional.AbstractTransactional
    implements Transactional {
        private final SequentialWriter indexFile;
        public final FileHandle.Builder builder;
        public final IndexSummaryBuilder summary;
        public final IFilter bf;
        private DataPosition mark;

        IndexWriter(long keyCount) {
            this.indexFile = new SequentialWriter(new File(BigTableWriter.this.descriptor.filenameFor(Component.PRIMARY_INDEX)), BigTableWriter.this.writerOption);
            this.builder = new FileHandle.Builder(BigTableWriter.this.descriptor.filenameFor(Component.PRIMARY_INDEX)).mmapped(DatabaseDescriptor.getIndexAccessMode() == Config.DiskAccessMode.mmap);
            BigTableWriter.this.chunkCache.ifPresent(this.builder::withChunkCache);
            this.summary = new IndexSummaryBuilder(keyCount, BigTableWriter.this.metadata().params.minIndexInterval, 128);
            this.bf = FilterFactory.getFilter(keyCount, BigTableWriter.this.metadata().params.bloomFilterFpChance);
            this.indexFile.setPostFlushListener(() -> this.summary.markIndexSynced(this.indexFile.getLastFlushOffset()));
            BigTableWriter.this.dataFile.setPostFlushListener(() -> this.summary.markDataSynced(BigTableWriter.this.dataFile.getLastFlushOffset()));
        }

        IndexSummaryBuilder.ReadableBoundary getMaxReadable() {
            return this.summary.getLastReadableBoundary();
        }

        public void append(DecoratedKey key, RowIndexEntry indexEntry, long dataEnd, ByteBuffer indexInfo) throws IOException {
            this.bf.add(key);
            long indexStart = this.indexFile.position();
            try {
                ByteBufferUtil.writeWithShortLength(key.getKey(), this.indexFile);
                BigTableWriter.this.rowIndexEntrySerializer.serialize(indexEntry, this.indexFile, indexInfo);
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.indexFile.getPath());
            }
            long indexEnd = this.indexFile.position();
            if (logger.isTraceEnabled()) {
                logger.trace("wrote index entry: {} at {}", (Object)indexEntry, (Object)indexStart);
            }
            this.summary.maybeAddEntry(key, indexStart, indexEnd, dataEnd);
        }

        void flushBf() {
            if (BigTableWriter.this.components.contains(Component.FILTER)) {
                String path = BigTableWriter.this.descriptor.filenameFor(Component.FILTER);
                try (FileOutputStreamPlus stream = new FileOutputStreamPlus(path);){
                    BloomFilterSerializer.serialize((BloomFilter)this.bf, stream);
                    stream.flush();
                    stream.sync();
                }
                catch (IOException e) {
                    throw new FSWriteError((Throwable)e, path);
                }
            }
        }

        public void mark() {
            this.mark = this.indexFile.mark();
        }

        public void resetAndTruncate() {
            this.indexFile.resetAndTruncate(this.mark);
        }

        @Override
        protected void doPrepare() {
            this.flushBf();
            long position = this.indexFile.position();
            this.indexFile.prepareToCommit();
            FileUtils.truncate(this.indexFile.getPath(), position);
            this.summary.prepareToCommit();
            try (IndexSummary indexSummary = this.summary.build(BigTableWriter.this.getPartitioner());){
                SSTableReader.saveSummary(BigTableWriter.this.descriptor, BigTableWriter.this.first, BigTableWriter.this.last, indexSummary);
            }
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            return this.indexFile.commit(accumulate);
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            return this.summary.close(this.indexFile.abort(accumulate));
        }

        @Override
        protected Throwable doPostCleanup(Throwable accumulate) {
            accumulate = this.summary.close(accumulate);
            accumulate = this.bf.close(accumulate);
            accumulate = this.builder.close(accumulate);
            return accumulate;
        }
    }

    class TransactionalProxy
    extends SSTableWriter.TransactionalProxy {
        TransactionalProxy() {
        }

        @Override
        protected void doPrepare() {
            BigTableWriter.this.iwriter.prepareToCommit();
            BigTableWriter.this.dataFile.prepareToCommit();
            BigTableWriter.this.writeMetadata(BigTableWriter.this.descriptor, BigTableWriter.this.finalizeMetadata());
            BigTableWriter.appendTOC(BigTableWriter.this.descriptor, BigTableWriter.this.components);
            if (this.openResult) {
                this.finalReader = BigTableWriter.this.openFinal(SSTableReader.OpenReason.NORMAL);
            }
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            accumulate = BigTableWriter.this.dataFile.commit(accumulate);
            accumulate = BigTableWriter.this.iwriter.commit(accumulate);
            return accumulate;
        }

        @Override
        protected Throwable doPostCleanup(Throwable accumulate) {
            accumulate = BigTableWriter.this.dbuilder.close(accumulate);
            return accumulate;
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            accumulate = BigTableWriter.this.iwriter.abort(accumulate);
            accumulate = BigTableWriter.this.dataFile.abort(accumulate);
            return accumulate;
        }
    }

    private static class StatsCollector
    extends Transformation {
        private final MetadataCollector collector;
        private int cellCount;

        StatsCollector(MetadataCollector collector) {
            this.collector = collector;
        }

        @Override
        public Row applyToStatic(Row row) {
            if (!row.isEmpty()) {
                this.cellCount += Rows.collectStats(row, this.collector);
            }
            return row;
        }

        @Override
        public Row applyToRow(Row row) {
            this.collector.updateClusteringValues(row.clustering());
            this.cellCount += Rows.collectStats(row, this.collector);
            return row;
        }

        @Override
        public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
            this.collector.updateClusteringValues(marker.clustering());
            if (marker.isBoundary()) {
                RangeTombstoneBoundaryMarker bm = (RangeTombstoneBoundaryMarker)marker;
                this.collector.update(bm.endDeletionTime());
                this.collector.update(bm.startDeletionTime());
            } else {
                this.collector.update(((RangeTombstoneBoundMarker)marker).deletionTime());
            }
            return marker;
        }

        @Override
        public void onPartitionClose() {
            this.collector.addCellPerPartitionCount(this.cellCount);
        }

        @Override
        public DeletionTime applyToDeletion(DeletionTime deletionTime) {
            this.collector.update(deletionTime);
            return deletionTime;
        }
    }
}

