/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import org.apache.cassandra.locator.AbstractEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;

public abstract class AbstractNetworkTopologySnitch
extends AbstractEndpointSnitch {
    @Override
    public abstract String getRack(InetAddressAndPort var1);

    @Override
    public abstract String getDatacenter(InetAddressAndPort var1);

    @Override
    public int compareEndpoints(InetAddressAndPort address, Replica r1, Replica r2) {
        InetAddressAndPort a1 = r1.endpoint();
        InetAddressAndPort a2 = r2.endpoint();
        if (address.equals(a1) && !address.equals(a2)) {
            return -1;
        }
        if (address.equals(a2) && !address.equals(a1)) {
            return 1;
        }
        String addressDatacenter = this.getDatacenter(address);
        String a1Datacenter = this.getDatacenter(a1);
        String a2Datacenter = this.getDatacenter(a2);
        if (addressDatacenter.equals(a1Datacenter) && !addressDatacenter.equals(a2Datacenter)) {
            return -1;
        }
        if (addressDatacenter.equals(a2Datacenter) && !addressDatacenter.equals(a1Datacenter)) {
            return 1;
        }
        String addressRack = this.getRack(address);
        String a1Rack = this.getRack(a1);
        String a2Rack = this.getRack(a2);
        if (addressRack.equals(a1Rack) && !addressRack.equals(a2Rack)) {
            return -1;
        }
        if (addressRack.equals(a2Rack) && !addressRack.equals(a1Rack)) {
            return 1;
        }
        return 0;
    }
}

