/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;
import org.apache.cassandra.locator.ReplicaMultimap;

public class EndpointsByReplica
extends ReplicaMultimap<Replica, EndpointsForRange> {
    public EndpointsByReplica(Map<Replica, EndpointsForRange> map) {
        super(map);
    }

    @Override
    public EndpointsForRange get(Replica range) {
        Preconditions.checkNotNull((Object)range);
        return this.map.getOrDefault(range, EndpointsForRange.empty(range.range()));
    }

    public static class Builder
    extends ReplicaMultimap.Builder<Replica, EndpointsForRange.Builder> {
        @Override
        protected EndpointsForRange.Builder newBuilder(Replica replica) {
            return new EndpointsForRange.Builder(replica.range());
        }

        public void putAll(Replica range, EndpointsForRange replicas, ReplicaCollection.Builder.Conflict ignoreConflicts) {
            this.map.computeIfAbsent(range, r -> this.newBuilder((Replica)r)).addAll(replicas, ignoreConflicts);
        }

        public EndpointsByReplica build() {
            return new EndpointsByReplica((Map<Replica, EndpointsForRange>)ImmutableMap.copyOf((Map)Maps.transformValues((Map)this.map, EndpointsForRange.Builder::build)));
        }
    }
}

