/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.util.List;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.RepairException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.CompletableRemoteSyncTask;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SyncTask;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.streaming.SessionSummary;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;

public class AsymmetricRemoteSyncTask
extends SyncTask
implements CompletableRemoteSyncTask {
    public AsymmetricRemoteSyncTask(RepairJobDesc desc, InetAddressAndPort to, InetAddressAndPort from, List<Range<Token>> differences, PreviewKind previewKind) {
        super(desc, to, from, differences, previewKind);
    }

    @Override
    public void startSync() {
        InetAddressAndPort local = FBUtilities.getBroadcastAddressAndPort();
        SyncRequest request = new SyncRequest(this.desc, local, this.nodePair.coordinator, this.nodePair.peer, this.rangesToSync, this.previewKind, true);
        String message = String.format("Forwarding streaming repair of %d ranges to %s (to be streamed with %s)", request.ranges.size(), request.src, request.dst);
        Tracing.traceRepair(message, new Object[0]);
        this.sendRequest(request, request.src);
    }

    @Override
    public void syncComplete(boolean success, List<SessionSummary> summaries) {
        if (success) {
            this.trySuccess(this.stat.withSummaries(summaries));
        } else {
            this.tryFailure(RepairException.warn(this.desc, this.previewKind, String.format("Sync failed between %s and %s", this.nodePair.coordinator, this.nodePair.peer)));
        }
    }

    @Override
    public String toString() {
        return "AsymmetricRemoteSyncTask{rangesToSync=" + this.rangesToSync + ", nodePair=" + this.nodePair + '}';
    }
}

