/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.ViewMetadata;

public interface SchemaChangeListener {
    default public void onCreateKeyspace(KeyspaceMetadata keyspace) {
    }

    default public void onCreateTable(TableMetadata table) {
    }

    default public void onCreateView(ViewMetadata view) {
        this.onCreateTable(view.metadata);
    }

    default public void onCreateType(UserType type) {
    }

    default public void onCreateFunction(UDFunction function) {
    }

    default public void onCreateAggregate(UDAggregate aggregate) {
    }

    default public void onAlterKeyspace(KeyspaceMetadata before, KeyspaceMetadata after) {
    }

    default public void onPreAlterTable(TableMetadata before, TableMetadata after) {
    }

    default public void onAlterTable(TableMetadata before, TableMetadata after, boolean affectStatements) {
    }

    default public void onPreAlterView(ViewMetadata before, ViewMetadata after) {
    }

    default public void onAlterView(ViewMetadata before, ViewMetadata after, boolean affectStatements) {
        this.onAlterTable(before.metadata, after.metadata, affectStatements);
    }

    default public void onAlterType(UserType before, UserType after) {
    }

    default public void onAlterFunction(UDFunction before, UDFunction after) {
    }

    default public void onAlterAggregate(UDAggregate before, UDAggregate after) {
    }

    default public void onDropKeyspace(KeyspaceMetadata keyspace, boolean dropData) {
    }

    default public void onDropTable(TableMetadata table, boolean dropData) {
    }

    default public void onDropView(ViewMetadata view, boolean dropData) {
        this.onDropTable(view.metadata, dropData);
    }

    default public void onDropType(UserType type) {
    }

    default public void onDropFunction(UDFunction function) {
    }

    default public void onDropAggregate(UDAggregate aggregate) {
    }
}

