/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.exceptions.UnknownTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;

public interface SchemaProvider {
    @Nullable
    public Keyspace getKeyspaceInstance(String var1);

    public Keyspace maybeAddKeyspaceInstance(String var1, Supplier<Keyspace> var2);

    @Nullable
    public KeyspaceMetadata getKeyspaceMetadata(String var1);

    @Nullable
    public TableMetadata getTableMetadata(TableId var1);

    @Nullable
    public TableMetadata getTableMetadata(String var1, String var2);

    default public TableMetadata getExistingTableMetadata(TableId id) throws UnknownTableException {
        TableMetadata metadata = this.getTableMetadata(id);
        if (metadata != null) {
            return metadata;
        }
        String message = String.format("Couldn't find table with id %s. If a table was just created, this is likely due to the schemanot being fully propagated.  Please wait for schema agreement on table creation.", id);
        throw new UnknownTableException(message, id);
    }

    @Nullable
    public TableMetadataRef getTableMetadataRef(String var1, String var2);

    @Nullable
    public TableMetadataRef getTableMetadataRef(TableId var1);

    @Nullable
    default public TableMetadataRef getTableMetadataRef(Descriptor descriptor) {
        return this.getTableMetadataRef(descriptor.ksname, descriptor.cfname);
    }
}

