/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.io.IOException;
import java.util.List;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.RequestCallbackWithFailure;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.Paxos;
import org.apache.cassandra.service.paxos.PaxosRequestCallback;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NullableSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosPrepareRefresh
implements RequestCallbackWithFailure<Response> {
    private static final Logger logger = LoggerFactory.getLogger(PaxosPrepareRefresh.class);
    public static final RequestHandler requestHandler = new RequestHandler();
    public static final RequestSerializer requestSerializer = new RequestSerializer();
    public static final ResponseSerializer responseSerializer = new ResponseSerializer();
    private final Message<Request> send;
    private final Callbacks callbacks;

    public PaxosPrepareRefresh(Ballot prepared, Paxos.Participants participants, Commit.Committed latestCommitted, Callbacks callbacks) {
        this.callbacks = callbacks;
        this.send = Message.out(Verb.PAXOS2_PREPARE_REFRESH_REQ, new Request(prepared, latestCommitted));
    }

    void refresh(List<InetAddressAndPort> refresh) {
        boolean executeOnSelf = false;
        int size = refresh.size();
        for (int i = 0; i < size; ++i) {
            InetAddressAndPort destination = refresh.get(i);
            if (logger.isTraceEnabled()) {
                logger.trace("Refresh {} and Confirm {} to {}", new Object[]{((Request)this.send.payload).missingCommit, Ballot.toString(((Request)this.send.payload).promised, "Promise"), destination});
            }
            if (Tracing.isTracing()) {
                Tracing.trace("Refresh {} and Confirm {} to {}", ((Request)this.send.payload).missingCommit.ballot, ((Request)this.send.payload).promised, destination);
            }
            if (PaxosRequestCallback.shouldExecuteOnSelf(destination)) {
                executeOnSelf = true;
                continue;
            }
            MessagingService.instance().sendWithCallback(this.send, destination, this);
        }
        if (executeOnSelf) {
            Verb.PAXOS2_PREPARE_REFRESH_REQ.stage.execute(this::executeOnSelf);
        }
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason reason) {
        this.callbacks.onRefreshFailure(from, reason);
    }

    @Override
    public void onResponse(Message<Response> message) {
        this.onResponse((Response)message.payload, message.from());
    }

    private void executeOnSelf() {
        Response response;
        try {
            response = RequestHandler.execute((Request)this.send.payload, FBUtilities.getBroadcastAddressAndPort());
            if (response == null) {
                return;
            }
        }
        catch (Exception ex) {
            RequestFailureReason reason = RequestFailureReason.UNKNOWN;
            if (ex instanceof WriteTimeoutException) {
                reason = RequestFailureReason.TIMEOUT;
            } else {
                logger.error("Failed to apply paxos refresh-prepare locally", (Throwable)ex);
            }
            this.onFailure(FBUtilities.getBroadcastAddressAndPort(), reason);
            return;
        }
        this.onResponse(response, FBUtilities.getBroadcastAddressAndPort());
    }

    private void onResponse(Response response, InetAddressAndPort from) {
        this.callbacks.onRefreshSuccess(response.isSupersededBy, from);
    }

    public static class ResponseSerializer
    implements IVersionedSerializer<Response> {
        @Override
        public void serialize(Response response, DataOutputPlus out, int version) throws IOException {
            NullableSerializer.serializeNullable(Ballot.Serializer.instance, response.isSupersededBy, out, version);
        }

        @Override
        public Response deserialize(DataInputPlus in, int version) throws IOException {
            Ballot isSupersededBy = NullableSerializer.deserializeNullable(Ballot.Serializer.instance, in, version);
            return new Response(isSupersededBy);
        }

        @Override
        public long serializedSize(Response response, int version) {
            return NullableSerializer.serializedSizeNullable(Ballot.Serializer.instance, response.isSupersededBy, version);
        }
    }

    public static class RequestSerializer
    implements IVersionedSerializer<Request> {
        @Override
        public void serialize(Request request, DataOutputPlus out, int version) throws IOException {
            request.promised.serialize(out);
            Commit.Committed.serializer.serialize(request.missingCommit, out, version);
        }

        @Override
        public Request deserialize(DataInputPlus in, int version) throws IOException {
            Ballot promise = Ballot.deserialize(in);
            Commit.Committed missingCommit = (Commit.Committed)Commit.Committed.serializer.deserialize(in, version);
            return new Request(promise, missingCommit);
        }

        @Override
        public long serializedSize(Request request, int version) {
            return Ballot.sizeInBytes() + Commit.Committed.serializer.serializedSize(request.missingCommit, version);
        }
    }

    public static class RequestHandler
    implements IVerbHandler<Request> {
        @Override
        public void doVerb(Message<Request> message) {
            Response response = RequestHandler.execute((Request)message.payload, message.from());
            if (response == null) {
                MessagingService.instance().respondWithFailure(RequestFailureReason.UNKNOWN, message);
            } else {
                MessagingService.instance().respond(response, message);
            }
        }

        public static Response execute(Request request, InetAddressAndPort from) {
            Commit.Committed commit = request.missingCommit;
            if (!Paxos.isInRangeAndShouldProcess(from, commit.update.partitionKey(), commit.update.metadata(), false)) {
                return null;
            }
            try (PaxosState state = PaxosState.get(commit);){
                state.commit(commit);
                Ballot latest = state.current(request.promised).latestWitnessedOrLowBound();
                if (Commit.isAfter(latest, request.promised)) {
                    Tracing.trace("Promise {} rescinded; latest is now {}", (Object)request.promised, (Object)latest);
                    Response response = new Response(latest);
                    return response;
                }
                Tracing.trace("Promise confirmed for ballot {}", (Object)request.promised);
                Response response = new Response(null);
                return response;
            }
        }
    }

    static class Response {
        final Ballot isSupersededBy;

        Response(Ballot isSupersededBy) {
            this.isSupersededBy = isSupersededBy;
        }
    }

    private static class Request {
        final Ballot promised;
        final Commit.Committed missingCommit;

        Request(Ballot promised, Commit.Committed missingCommit) {
            this.promised = promised;
            this.missingCommit = missingCommit;
        }
    }

    static interface Callbacks {
        public void onRefreshFailure(InetAddressAndPort var1, RequestFailureReason var2);

        public void onRefreshSuccess(Ballot var1, InetAddressAndPort var2);
    }
}

