/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.transform.EmptyPartitionsDiscarder;
import org.apache.cassandra.db.transform.Filter;
import org.apache.cassandra.db.transform.FilteredPartitions;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.reads.ReplicaFilteringProtection;
import org.apache.cassandra.service.reads.ResponseResolver;
import org.apache.cassandra.service.reads.ShortReadProtection;
import org.apache.cassandra.service.reads.repair.NoopReadRepair;
import org.apache.cassandra.service.reads.repair.ReadRepair;
import org.apache.cassandra.service.reads.repair.RepairedDataTracker;
import org.apache.cassandra.service.reads.repair.RepairedDataVerifier;
import org.apache.cassandra.transport.Dispatcher;

public class DataResolver<E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E, P>>
extends ResponseResolver<E, P> {
    private final boolean enforceStrictLiveness;
    private final ReadRepair<E, P> readRepair;
    private final boolean trackRepairedStatus;

    public DataResolver(ReadCommand command, Supplier<? extends P> replicaPlan, ReadRepair<E, P> readRepair, Dispatcher.RequestTime requestTime) {
        this(command, replicaPlan, readRepair, requestTime, false);
    }

    public DataResolver(ReadCommand command, Supplier<? extends P> replicaPlan, ReadRepair<E, P> readRepair, Dispatcher.RequestTime requestTime, boolean trackRepairedStatus) {
        super(command, replicaPlan, requestTime);
        this.enforceStrictLiveness = command.metadata().enforceStrictLiveness();
        this.readRepair = readRepair;
        this.trackRepairedStatus = trackRepairedStatus;
    }

    public PartitionIterator getData() {
        ReadResponse response = (ReadResponse)((Message)this.responses.get((int)0)).payload;
        return UnfilteredPartitionIterators.filter(response.makeIterator(this.command), this.command.nowInSec());
    }

    @Override
    public boolean isDataPresent() {
        return !this.responses.isEmpty();
    }

    public PartitionIterator resolve() {
        return this.resolve(null);
    }

    public PartitionIterator resolve(@Nullable Runnable runOnShortRead) {
        RepairedDataTracker repairedDataTracker;
        Collection messages = this.responses.snapshot();
        assert (!Iterables.any(messages, msg -> ((ReadResponse)msg.payload).isDigestResponse()));
        Object replicas = ((Endpoints)this.replicaPlan().readCandidates()).select(Iterables.transform(messages, Message::from), false);
        RepairedDataTracker repairedDataTracker2 = repairedDataTracker = this.trackRepairedStatus ? new RepairedDataTracker(this.getRepairedDataVerifier(this.command)) : null;
        if (repairedDataTracker != null) {
            messages.forEach(msg -> {
                if (((ReadResponse)msg.payload).mayIncludeRepairedDigest() && replicas.byEndpoint().get(msg.from()).isFull()) {
                    repairedDataTracker.recordDigest(msg.from(), ((ReadResponse)msg.payload).repairedDataDigest(), ((ReadResponse)msg.payload).isRepairedDigestConclusive());
                }
            });
        }
        if (!this.needsReplicaFilteringProtection()) {
            ResolveContext context = new ResolveContext(this, (Endpoints)replicas);
            return this.resolveWithReadRepair(context, i -> this.shortReadProtectedResponse(i, context, runOnShortRead), UnaryOperator.identity(), repairedDataTracker);
        }
        return this.resolveWithReplicaFilteringProtection(replicas, repairedDataTracker);
    }

    private boolean needsReplicaFilteringProtection() {
        if (this.command.rowFilter().isEmpty()) {
            return false;
        }
        IndexMetadata indexMetadata = this.command.indexMetadata();
        if (indexMetadata == null || !indexMetadata.isCustom()) {
            return true;
        }
        ColumnFamilyStore cfs = ColumnFamilyStore.getIfExists(this.command.metadata().id);
        assert (cfs != null);
        Index index = this.command.getIndex(cfs);
        assert (index != null);
        return index.supportsReplicaFilteringProtection(this.command.rowFilter());
    }

    private UnfilteredPartitionIterator shortReadProtectedResponse(int i, ResolveContext context, @Nullable Runnable onShortRead) {
        UnfilteredPartitionIterator originalResponse = ((ReadResponse)((Message)this.responses.get((int)i)).payload).makeIterator(this.command);
        return context.needShortReadProtection() ? ShortReadProtection.extend(context.replicas.get(i), () -> {
            this.responses.clearUnsafe(i);
            if (onShortRead != null) {
                onShortRead.run();
            }
        }, originalResponse, this.command, context.mergedResultCounter, this.requestTime, this.enforceStrictLiveness) : originalResponse;
    }

    private PartitionIterator resolveWithReadRepair(ResolveContext context, ResponseProvider responseProvider, UnaryOperator<PartitionIterator> preCountFilter, RepairedDataTracker repairedDataTracker) {
        UnfilteredPartitionIterators.MergeListener listener = null;
        if (context.needsReadRepair() && this.readRepair != NoopReadRepair.instance) {
            ReplicaPlan.ForRead sources = (ReplicaPlan.ForRead)((ReplicaPlan.ForRead)this.replicaPlan.get()).withContacts(context.replicas);
            listener = this.wrapMergeListener(this.readRepair.getMergeListener(sources), sources, repairedDataTracker);
        }
        return this.resolveInternal(context, listener, responseProvider, preCountFilter);
    }

    private PartitionIterator resolveWithReplicaFilteringProtection(E replicas, RepairedDataTracker repairedDataTracker) {
        ResolveContext firstPhaseContext = new ResolveContext(this, (Endpoints)replicas);
        ResolveContext secondPhaseContext = new ResolveContext(this, (Endpoints)replicas);
        ReplicaFilteringProtection<Endpoints> rfp = new ReplicaFilteringProtection<Endpoints>(this.replicaPlan().keyspace(), this.command, this.replicaPlan().consistencyLevel(), this.requestTime, firstPhaseContext.replicas, DatabaseDescriptor.getCachedReplicaRowsWarnThreshold(), DatabaseDescriptor.getCachedReplicaRowsFailThreshold());
        PartitionIterator firstPhasePartitions = this.resolveInternal(firstPhaseContext, rfp.mergeController(), i -> this.shortReadProtectedResponse(i, firstPhaseContext, null), UnaryOperator.identity());
        PartitionIterator completedPartitions = this.resolveWithReadRepair(secondPhaseContext, i -> rfp.queryProtectedPartitions(firstPhasePartitions, i), results -> this.command.rowFilter().filter((PartitionIterator)results, this.command.metadata(), this.command.nowInSec()), repairedDataTracker);
        return PartitionIterators.doOnClose(completedPartitions, firstPhasePartitions::close);
    }

    private PartitionIterator resolveInternal(ResolveContext context, UnfilteredPartitionIterators.MergeListener mergeListener, ResponseProvider responseProvider, UnaryOperator<PartitionIterator> preCountFilter) {
        int count = context.replicas.size();
        ArrayList<UnfilteredPartitionIterator> results = new ArrayList<UnfilteredPartitionIterator>(count);
        for (int i = 0; i < count; ++i) {
            results.add(responseProvider.getResponse(i));
        }
        UnfilteredPartitionIterator merged = UnfilteredPartitionIterators.merge(results, mergeListener);
        Filter filter = new Filter(this.command.nowInSec(), this.command.metadata().enforceStrictLiveness());
        FilteredPartitions filtered = FilteredPartitions.filter(merged, filter);
        PartitionIterator counted = Transformation.apply((PartitionIterator)preCountFilter.apply(filtered), context.mergedResultCounter);
        return Transformation.apply(counted, new EmptyPartitionsDiscarder());
    }

    protected RepairedDataVerifier getRepairedDataVerifier(ReadCommand command) {
        return RepairedDataVerifier.verifier(command);
    }

    private String makeResponsesDebugString(DecoratedKey partitionKey) {
        return Joiner.on((String)",\n").join(Iterables.transform(this.getMessages().snapshot(), m -> m.from() + " => " + ((ReadResponse)m.payload).toDebugString(this.command, partitionKey)));
    }

    private UnfilteredPartitionIterators.MergeListener wrapMergeListener(final UnfilteredPartitionIterators.MergeListener partitionListener, P sources, final RepairedDataTracker repairedDataTracker) {
        if (partitionListener == UnfilteredPartitionIterators.MergeListener.NOOP) {
            if (repairedDataTracker == null) {
                return partitionListener;
            }
            return new UnfilteredPartitionIterators.MergeListener(){

                @Override
                public UnfilteredRowIterators.MergeListener getRowMergeListener(DecoratedKey partitionKey, List<UnfilteredRowIterator> versions) {
                    return UnfilteredRowIterators.MergeListener.NOOP;
                }

                @Override
                public void close() {
                    repairedDataTracker.verify();
                }
            };
        }
        return new UnfilteredPartitionIterators.MergeListener((ReplicaPlan.ForRead)sources, repairedDataTracker){
            final /* synthetic */ ReplicaPlan.ForRead val$sources;
            final /* synthetic */ RepairedDataTracker val$repairedDataTracker;
            {
                this.val$sources = forRead;
                this.val$repairedDataTracker = repairedDataTracker;
            }

            @Override
            public UnfilteredRowIterators.MergeListener getRowMergeListener(final DecoratedKey partitionKey, List<UnfilteredRowIterator> versions) {
                final UnfilteredRowIterators.MergeListener rowListener = partitionListener.getRowMergeListener(partitionKey, versions);
                return new UnfilteredRowIterators.MergeListener(){

                    @Override
                    public void onMergedPartitionLevelDeletion(DeletionTime mergedDeletion, DeletionTime[] versions) {
                        try {
                            rowListener.onMergedPartitionLevelDeletion(mergedDeletion, versions);
                        }
                        catch (AssertionError e) {
                            TableMetadata table = DataResolver.this.command.metadata();
                            String details = String.format("Error merging partition level deletion on %s: merged=%s, versions=%s, sources={%s}, debug info:%n %s", table, mergedDeletion == null ? "null" : mergedDeletion.toString(), '[' + Joiner.on((String)", ").join(Iterables.transform(Arrays.asList(versions), rt -> rt == null ? "null" : rt.toString())) + ']', val$sources.contacts(), DataResolver.this.makeResponsesDebugString(partitionKey));
                            throw new AssertionError(details, (Throwable)((Object)e));
                        }
                    }

                    @Override
                    public Row onMergedRows(Row merged, Row[] versions) {
                        try {
                            return rowListener.onMergedRows(merged, versions);
                        }
                        catch (AssertionError e) {
                            TableMetadata table = DataResolver.this.command.metadata();
                            String details = String.format("Error merging rows on %s: merged=%s, versions=%s, sources={%s}, debug info:%n %s", table, merged == null ? "null" : merged.toString(table), '[' + Joiner.on((String)", ").join(Iterables.transform(Arrays.asList(versions), rt -> rt == null ? "null" : rt.toString(table))) + ']', val$sources.contacts(), DataResolver.this.makeResponsesDebugString(partitionKey));
                            throw new AssertionError(details, (Throwable)((Object)e));
                        }
                    }

                    @Override
                    public void onMergedRangeTombstoneMarkers(RangeTombstoneMarker merged, RangeTombstoneMarker[] versions) {
                        try {
                            rowListener.onMergedRangeTombstoneMarkers(merged, versions);
                        }
                        catch (AssertionError e) {
                            TableMetadata table = DataResolver.this.command.metadata();
                            String details = String.format("Error merging RTs on %s: merged=%s, versions=%s, sources={%s}, debug info:%n %s", table, merged == null ? "null" : merged.toString(table), '[' + Joiner.on((String)", ").join(Iterables.transform(Arrays.asList(versions), rt -> rt == null ? "null" : rt.toString(table))) + ']', val$sources.contacts(), DataResolver.this.makeResponsesDebugString(partitionKey));
                            throw new AssertionError(details, (Throwable)((Object)e));
                        }
                    }

                    @Override
                    public void close() {
                        rowListener.close();
                    }
                };
            }

            @Override
            public void close() {
                partitionListener.close();
                if (this.val$repairedDataTracker != null) {
                    this.val$repairedDataTracker.verify();
                }
            }
        };
    }

    @FunctionalInterface
    private static interface ResponseProvider {
        public UnfilteredPartitionIterator getResponse(int var1);
    }

    private static class ResolveContext {
        private final E replicas;
        private final DataLimits.Counter mergedResultCounter;
        final /* synthetic */ DataResolver this$0;

        private ResolveContext(E replicas) {
            this.this$0 = var1_1;
            this.replicas = replicas;
            this.mergedResultCounter = var1_1.command.limits().newCounter(var1_1.command.nowInSec(), true, var1_1.command.selectsFullPartition(), ((DataResolver)var1_1).enforceStrictLiveness);
        }

        private boolean needsReadRepair() {
            return ((AbstractReplicaCollection)this.replicas).size() > 1;
        }

        private boolean needShortReadProtection() {
            return ((AbstractReplicaCollection)this.replicas).size() > 1 && !this.this$0.command.limits().isUnlimited();
        }
    }
}

