/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.concurrent.Awaitable;

@Shared(scope={Shared.Scope.SIMULATION})
public interface CountDownLatch
extends Awaitable {
    public void decrement();

    public int count();

    public static CountDownLatch newCountDownLatch(int count) {
        return new Async(count);
    }

    public static final class Sync
    extends Awaitable.SyncAwaitable
    implements CountDownLatch {
        private int count;

        public Sync(int count) {
            this.count = count;
        }

        @Override
        public synchronized void decrement() {
            if (this.count > 0 && --this.count == 0) {
                this.notifyAll();
            }
        }

        @Override
        public synchronized int count() {
            return this.count;
        }

        @Override
        protected boolean isSignalled() {
            return this.count <= 0;
        }
    }

    public static class Async
    extends Awaitable.AsyncAwaitable
    implements CountDownLatch {
        private static final AtomicIntegerFieldUpdater<Async> countUpdater = AtomicIntegerFieldUpdater.newUpdater(Async.class, "count");
        private volatile int count;

        protected Async(int count) {
            this.count = count;
            if (count == 0) {
                this.signal();
            }
        }

        @Override
        public void decrement() {
            if (countUpdater.decrementAndGet(this) == 0) {
                this.signal();
            }
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        protected boolean isSignalled() {
            return this.count <= 0;
        }
    }
}

