/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.util.formating;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import org.gridkit.util.formating.NumberFormat;
import org.gridkit.util.formating.SimpleNumberFormatter;
import org.gridkit.util.formating.TableFormatter;
import org.gridkit.util.formating.TabularDataSink;
import org.gridkit.util.formating.TextTable;

public class CsvTableFormatter
implements TableFormatter,
TabularDataSink {
    protected TextTable textTable = new TextTable();
    protected List<String> header = new ArrayList<String>();
    protected List<String> displayHeader = new ArrayList<String>();
    protected List<NumberFormat> numberFormat = new ArrayList<NumberFormat>();
    protected TimeZone timeZone;

    public CsvTableFormatter() {
        this(TimeZone.getDefault());
    }

    public CsvTableFormatter(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public void addCol(String name) {
        this.header.add(name);
        this.displayHeader.add(name);
        this.numberFormat.add(SimpleNumberFormatter.DEFAULT);
    }

    @Override
    public void addCol(String name, String displayName) {
        this.header.add(name);
        this.displayHeader.add(displayName);
        this.numberFormat.add(SimpleNumberFormatter.DEFAULT);
    }

    @Override
    public void addCol(String name, String displayName, String format) {
        this.header.add(name);
        this.displayHeader.add(displayName);
        this.numberFormat.add(new SimpleNumberFormatter(format, this.timeZone));
    }

    protected String formatDouble(String name, double v) {
        return this.numberFormat.get(this.header.indexOf(name)).formatDouble(v);
    }

    protected String formatLong(String name, long v) {
        return this.numberFormat.get(this.header.indexOf(name)).formatLong(v);
    }

    @Override
    public int colByName(String name) {
        return this.header.indexOf(name);
    }

    public String format() {
        return TextTable.formatCsv(this.textTable);
    }

    @Override
    public void format(Appendable out) throws IOException {
        out.append(this.format());
    }

    @Override
    public void sort(String colId, boolean desc) {
        this.textTable.sort(this.colByName(colId), true, desc, null);
    }

    @Override
    public void sortNumeric(String colId, boolean desc) {
        this.textTable.sort(this.colByName(colId), true, desc, TextTable.NUM_CMP);
    }

    @Override
    public void close() {
    }

    protected void addRow(String[] row) {
        if (this.textTable.rowCount() == 0) {
            this.textTable.addRow(this.displayHeader.toArray(new String[0]));
        }
        this.textTable.addRow(row);
    }

    @Override
    public TabularDataSink.Cursor newCursor() {
        return new TabularDataSink.Cursor(){
            final String[] row;
            {
                this.row = new String[CsvTableFormatter.this.header.size()];
                this.clear();
            }

            @Override
            public void submit() {
                CsvTableFormatter.this.addRow(this.row);
                this.clear();
            }

            private void clear() {
                Arrays.fill(this.row, "");
            }

            @Override
            public void setCell(int colNo, double value) {
                if (colNo >= 0) {
                    this.row[colNo] = CsvTableFormatter.this.formatDouble(CsvTableFormatter.this.header.get(colNo), value);
                }
            }

            @Override
            public void setCell(int colNo, long value) {
                if (colNo >= 0) {
                    this.row[colNo] = CsvTableFormatter.this.formatLong(CsvTableFormatter.this.header.get(colNo), value);
                }
            }

            @Override
            public void setCell(int colNo, String value) {
                if (colNo >= 0) {
                    this.row[colNo] = value;
                }
            }

            @Override
            public void setCell(String name, double value) {
                this.setCell(CsvTableFormatter.this.colByName(name), value);
            }

            @Override
            public void setCell(String name, long value) {
                this.setCell(CsvTableFormatter.this.colByName(name), value);
            }

            @Override
            public void setCell(String name, String value) {
                this.setCell(CsvTableFormatter.this.colByName(name), value);
            }
        };
    }
}

