/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.userdefined;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.io.sstable.StressCQLSSTableWriter;
import org.apache.cassandra.stress.WorkManager;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionFixed;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.PartitionIterator;
import org.apache.cassandra.stress.generate.RatioDistribution;
import org.apache.cassandra.stress.generate.Row;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.PartitionOperation;
import org.apache.cassandra.stress.operations.userdefined.SchemaStatement;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;

public class SchemaInsert
extends SchemaStatement {
    private final String tableSchema;
    private final String insertStatement;
    private final BatchStatement.Type batchType;

    public SchemaInsert(Timer timer, StressSettings settings, PartitionGenerator generator, SeedManager seedManager, Distribution batchSize, RatioDistribution useRatio, RatioDistribution rowPopulation, PreparedStatement statement, ConsistencyLevel cl, BatchStatement.Type batchType) {
        super(timer, settings, new PartitionOperation.DataSpec(generator, seedManager, batchSize, useRatio, rowPopulation), statement, statement.getVariables().asList().stream().map(d -> d.getName()).collect(Collectors.toList()), cl);
        this.batchType = batchType;
        this.insertStatement = null;
        this.tableSchema = null;
    }

    public SchemaInsert(Timer timer, StressSettings settings, PartitionGenerator generator, SeedManager seedManager, RatioDistribution useRatio, RatioDistribution rowPopulation, String statement, String tableSchema) {
        super(timer, settings, new PartitionOperation.DataSpec(generator, seedManager, (Distribution)new DistributionFixed(1L), useRatio, rowPopulation), null, generator.getColumnNames(), ConsistencyLevel.ONE);
        this.batchType = BatchStatement.Type.UNLOGGED;
        this.insertStatement = statement;
        this.tableSchema = tableSchema;
    }

    @Override
    public void run(JavaDriverClient client) throws IOException {
        this.timeWithRetry(new JavaDriverRun(client));
    }

    @Override
    public boolean isWrite() {
        return true;
    }

    public StressCQLSSTableWriter createWriter(ColumnFamilyStore cfs, int bufferSize, boolean makeRangeAware) {
        return StressCQLSSTableWriter.builder().withCfs(cfs).withBufferSizeInMiB(bufferSize).forTable(this.tableSchema).using(this.insertStatement).rangeAware(makeRangeAware).build();
    }

    public void runOffline(StressCQLSSTableWriter writer, WorkManager workManager) throws Exception {
        OfflineRun offline = new OfflineRun(writer);
        while (this.ready(workManager) != 0) {
            offline.run();
        }
    }

    private class OfflineRun
    extends SchemaStatement.Runner {
        final StressCQLSSTableWriter writer;

        OfflineRun(StressCQLSSTableWriter writer) {
            super(SchemaInsert.this);
            this.writer = writer;
        }

        @Override
        public boolean run() throws Exception {
            for (PartitionIterator iterator : SchemaInsert.this.partitions) {
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    this.writer.rawAddRow(SchemaInsert.this.rowArgs(row));
                    ++this.rowCount;
                }
            }
            return true;
        }
    }

    private class JavaDriverRun
    extends SchemaStatement.Runner {
        final JavaDriverClient client;

        private JavaDriverRun(JavaDriverClient client) {
            super(SchemaInsert.this);
            this.client = client;
        }

        @Override
        public boolean run() throws Exception {
            ArrayList<BoundStatement> stmts = new ArrayList<BoundStatement>();
            this.partitionCount = SchemaInsert.this.partitions.size();
            for (PartitionIterator iterator : SchemaInsert.this.partitions) {
                while (iterator.hasNext()) {
                    stmts.add(SchemaInsert.this.bindRow((Row)iterator.next()));
                }
            }
            this.rowCount += stmts.size();
            for (int j = 0; j < stmts.size(); j += 65535) {
                Statement stmt;
                List substmts = stmts.subList(j, Math.min(j + stmts.size(), j + 65535));
                if (stmts.size() == 1) {
                    stmt = (Statement)substmts.get(0);
                } else {
                    BatchStatement batch = new BatchStatement(SchemaInsert.this.batchType);
                    if (SchemaInsert.this.cl.isSerialConsistency()) {
                        batch.setSerialConsistencyLevel(JavaDriverClient.from(SchemaInsert.this.cl));
                    } else {
                        batch.setConsistencyLevel(JavaDriverClient.from(SchemaInsert.this.cl));
                    }
                    batch.addAll(substmts);
                    stmt = batch;
                }
                this.client.getSession().execute(stmt);
            }
            return true;
        }
    }
}

