/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.tree.segmenttree;

import org.psjava.ds.array.Array;
import org.psjava.ds.math.BinaryOperator;
import org.psjava.ds.tree.BinaryTreeByArray;
import org.psjava.ds.tree.segmenttree.SegmentTree;
import org.psjava.util.AssertStatus;

public class SegmentTreeByArrayImplementation<T>
implements SegmentTree<T> {
    private final BinaryOperator<T> merger;
    private final BinaryTreeByArray<T> tree;
    private final int size;

    public SegmentTreeByArrayImplementation(Array<T> initialData, BinaryOperator<T> merger) {
        this.merger = merger;
        this.size = initialData.size();
        this.tree = new BinaryTreeByArray();
        int root = this.tree.createRoot(initialData.get(0));
        this.construct(root, initialData, 0, initialData.size());
    }

    private void construct(int node, Array<T> initialData, int start, int end) {
        if (end - start == 1) {
            this.tree.setValue(node, initialData.get(start));
        } else {
            T any = initialData.get(0);
            int mid = (start + end) / 2;
            int left = this.tree.putChild(node, false, any);
            int right = this.tree.putChild(node, true, any);
            this.construct(left, initialData, start, mid);
            this.construct(right, initialData, mid, end);
            this.tree.setValue(node, this.merger.calc(this.tree.getValue(left), this.tree.getValue(right)));
        }
    }

    @Override
    public T query(int start, int end) {
        AssertStatus.assertTrue(start < end, "invalid range");
        return this.queryRecursively(this.tree.getRootPointer(), 0, this.size, start, end);
    }

    private T queryRecursively(int node, int nodeStart, int nodeEnd, int start, int end) {
        if (nodeStart == start && nodeEnd == end) {
            return this.tree.getValue(node);
        }
        int mid = (nodeStart + nodeEnd) / 2;
        if (end <= mid) {
            return this.queryRecursively(this.tree.getLeft(node), nodeStart, mid, start, end);
        }
        if (mid <= start) {
            return this.queryRecursively(this.tree.getRight(node), mid, nodeEnd, start, end);
        }
        return this.merger.calc(this.queryRecursively(this.tree.getLeft(node), nodeStart, mid, start, mid), this.queryRecursively(this.tree.getRight(node), mid, nodeEnd, mid, end));
    }

    @Override
    public void update(int position, T value) {
        this.updateRecursively(this.tree.getRootPointer(), 0, this.size, position, value);
    }

    private void updateRecursively(int node, int nodeStart, int nodeEnd, int position, T value) {
        if (nodeEnd - nodeStart == 1) {
            this.tree.setValue(node, value);
        } else {
            int left = this.tree.getLeft(node);
            int right = this.tree.getRight(node);
            int mid = (nodeStart + nodeEnd) / 2;
            if (position < mid) {
                this.updateRecursively(left, nodeStart, mid, position, value);
            } else {
                this.updateRecursively(right, mid, nodeEnd, position, value);
            }
            this.tree.setValue(node, this.merger.calc(this.tree.getValue(left), this.tree.getValue(right)));
        }
    }
}

