/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.tree.trie;

import org.psjava.ds.tree.trie.TrieNode;
import org.psjava.ds.tree.trie.TrieNodeFactory;
import org.psjava.util.ConvertedDataIterable;
import org.psjava.util.DataConverter;
import org.psjava.util.StringMerger;

public class Trie<T> {
    private final TrieNodeFactory<T> factory;
    private final TrieNode<T> root;

    public Trie(TrieNodeFactory<T> nodeFactory) {
        this.factory = nodeFactory;
        this.root = this.factory.create();
    }

    public void add(Iterable<T> sequence) {
        TrieNode<T> cur = this.root;
        for (T v : sequence) {
            TrieNode<T> subTrie = cur.getChildOrNull(v);
            if (subTrie == null) {
                subTrie = this.factory.create();
                cur.putChild(v, subTrie);
            }
            cur = subTrie;
        }
    }

    public TrieNode<T> getRoot() {
        return this.root;
    }

    public String toString() {
        return this.getNodeString(this.root);
    }

    private String getNodeString(final TrieNode<T> node) {
        String r = "";
        if (node == this.root) {
            r = r + "Trie";
        }
        if (node.getChildCount() > 0) {
            r = r + "(";
            r = r + StringMerger.merge(ConvertedDataIterable.create(node.getEdges(), new DataConverter<T, String>(){

                @Override
                public String convert(T c) {
                    return c + Trie.this.getNodeString(node.getChild(c));
                }
            }), ",");
            r = r + ")";
        }
        return r;
    }
}

