/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.analytics;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.internal.analytics.MuteBuilder;
import net.openhft.chronicle.core.internal.analytics.ReflectionUtil;
import net.openhft.chronicle.core.internal.analytics.ReflectiveBuilder;
import net.openhft.chronicle.core.internal.analytics.StandardMaps;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public interface AnalyticsFacade {
    default public void sendEvent(@NotNull String name) {
        this.sendEvent(name, Collections.emptyMap());
    }

    public void sendEvent(@NotNull String var1, @NotNull Map<String, String> var2);

    public static boolean isEnabled() {
        return ReflectionUtil.analyticsPresent() && !Jvm.getBoolean("chronicle.analytics.disable");
    }

    @NotNull
    public static Builder builder(@NotNull String measurementId, @NotNull String apiSecret) {
        ObjectUtils.requireNonNull(measurementId);
        ObjectUtils.requireNonNull(apiSecret);
        if (AnalyticsFacade.isEnabled()) {
            return new ReflectiveBuilder(measurementId, apiSecret);
        }
        return MuteBuilder.INSTANCE;
    }

    @NotNull
    public static Builder standardBuilder(@NotNull String measurementId, @NotNull String apiSecret, @NotNull String appVersion) {
        ObjectUtils.requireNonNull(measurementId);
        ObjectUtils.requireNonNull(apiSecret);
        ObjectUtils.requireNonNull(appVersion);
        Builder builder = AnalyticsFacade.builder(measurementId, apiSecret);
        AnalyticsFacade.standardEventParameters(appVersion).forEach(builder::putEventParameter);
        AnalyticsFacade.standardUserProperties().forEach(builder::putUserProperty);
        builder.withFrequencyLimit(4, 1L, TimeUnit.HOURS);
        return builder;
    }

    @NotNull
    public static Map<String, String> standardEventParameters(@NotNull String appVersion) {
        ObjectUtils.requireNonNull(appVersion);
        return StandardMaps.standardEventParameters(appVersion);
    }

    @NotNull
    public static Map<String, String> standardUserProperties() {
        return StandardMaps.standardUserProperties();
    }

    public static Map<String, String> standardAdditionalProperties() {
        return StandardMaps.standardAdditionalEventParameters();
    }

    public static interface Builder {
        @NotNull
        public Builder putUserProperty(@NotNull String var1, @NotNull String var2);

        @NotNull
        public Builder putEventParameter(@NotNull String var1, @NotNull String var2);

        @NotNull
        public Builder withFrequencyLimit(int var1, long var2, @NotNull TimeUnit var4);

        @NotNull
        public Builder withErrorLogger(@NotNull Consumer<? super String> var1);

        @NotNull
        public Builder withDebugLogger(@NotNull Consumer<? super String> var1);

        @NotNull
        public Builder withClientIdFileName(@NotNull String var1);

        @NotNull
        public Builder withUrl(@NotNull String var1);

        @NotNull
        public Builder withReportDespiteJUnit();

        @NotNull
        public AnalyticsFacade build();
    }
}

