/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.unified;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.ShardTracker;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedCompactionWriter
extends CompactionAwareWriter {
    protected static final Logger logger = LoggerFactory.getLogger(ShardedCompactionWriter.class);
    private final double uniqueKeyRatio;
    private final ShardTracker boundaries;

    public ShardedCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, boolean keepOriginals, ShardTracker boundaries) {
        super(cfs, directories, txn, nonExpiredSSTables, keepOriginals);
        this.boundaries = boundaries;
        long totalKeyCount = nonExpiredSSTables.stream().mapToLong(SSTableReader::estimatedKeys).sum();
        this.uniqueKeyRatio = 1.0 * (double)SSTableReader.getApproximateKeyCount(nonExpiredSSTables) / (double)totalKeyCount;
    }

    @Override
    protected boolean shouldSwitchWriterInCurrentLocation(DecoratedKey key) {
        long uncompressedBytesWritten = this.sstableWriter.currentWriter().getFilePointer();
        if (this.boundaries.advanceTo(key.getToken()) && uncompressedBytesWritten > 0L) {
            logger.debug("Switching writer at boundary {}/{} index {}, with uncompressed size {} for {}.{}", new Object[]{key.getToken(), this.boundaries.shardStart(), this.boundaries.shardIndex(), FBUtilities.prettyPrintMemory(uncompressedBytesWritten), this.cfs.getKeyspaceName(), this.cfs.getTableName()});
            return true;
        }
        return false;
    }

    @Override
    protected SSTableWriter sstableWriter(Directories.DataDirectory directory, DecoratedKey nextKey) {
        if (nextKey != null) {
            this.boundaries.advanceTo(nextKey.getToken());
        }
        return super.sstableWriter(directory, nextKey);
    }

    @Override
    protected long sstableKeyCount() {
        return ShardedCompactionWriter.shardAdjustedKeyCount(this.boundaries, this.nonExpiredSSTables, this.uniqueKeyRatio);
    }

    private static long shardAdjustedKeyCount(ShardTracker boundaries, Set<SSTableReader> sstables, double survivalRatio) {
        return Math.round((double)boundaries.shardAdjustedKeyCount(sstables) * survivalRatio);
    }

    @Override
    protected void doPrepare() {
        this.sstableWriter.forEachWriter(this.boundaries::applyTokenSpaceCoverage);
        super.doPrepare();
    }
}

