/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.tries;

import org.apache.cassandra.db.tries.Trie;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

public class SlicedTrie<T>
extends Trie<T> {
    private final Trie<T> source;
    private final ByteComparable left;
    private final ByteComparable right;
    private final boolean includeLeft;
    private final boolean includeRight;

    public SlicedTrie(Trie<T> source, ByteComparable left, boolean includeLeft, ByteComparable right, boolean includeRight) {
        this.source = source;
        this.left = left;
        this.right = right;
        this.includeLeft = includeLeft;
        this.includeRight = includeRight;
    }

    @Override
    protected Trie.Cursor<T> cursor() {
        return new SlicedCursor(this);
    }

    private static class SlicedCursor<T>
    implements Trie.Cursor<T> {
        private final ByteSource left;
        private final ByteSource right;
        private final boolean includeLeft;
        private final boolean excludeRight;
        private final Trie.Cursor<T> source;
        private State state;
        private int leftNext;
        private int leftNextDepth;
        private int rightNext;
        private int rightNextDepth;

        public SlicedCursor(SlicedTrie<T> slicedTrie) {
            this.source = slicedTrie.source.cursor();
            if (slicedTrie.left != null) {
                this.left = slicedTrie.left.asComparableBytes(Trie.BYTE_COMPARABLE_VERSION);
                this.includeLeft = slicedTrie.includeLeft;
                this.leftNext = this.left.next();
                this.leftNextDepth = 1;
                this.state = this.leftNext == -1 && this.includeLeft ? State.INSIDE : State.BEFORE_LEFT;
            } else {
                this.left = null;
                this.includeLeft = true;
                this.state = State.INSIDE;
            }
            if (slicedTrie.right != null) {
                this.right = slicedTrie.right.asComparableBytes(Trie.BYTE_COMPARABLE_VERSION);
                this.excludeRight = !slicedTrie.includeRight;
                this.rightNext = this.right.next();
                this.rightNextDepth = 1;
                if (this.rightNext == -1 && this.excludeRight) {
                    this.state = State.BEFORE_LEFT;
                }
            } else {
                this.right = null;
                this.excludeRight = true;
                this.rightNextDepth = 0;
            }
        }

        @Override
        public int advance() {
            assert (this.state != State.AFTER_RIGHT);
            int newDepth = this.source.advance();
            int transition = this.source.incomingTransition();
            if (this.state == State.BEFORE_LEFT) {
                while (newDepth == this.leftNextDepth && transition < this.leftNext) {
                    newDepth = this.source.skipChildren();
                    transition = this.source.incomingTransition();
                }
                if (newDepth == this.leftNextDepth && transition == this.leftNext) {
                    assert (this.leftNext != -1);
                    this.leftNext = this.left.next();
                    ++this.leftNextDepth;
                    if (this.leftNext == -1 && this.includeLeft) {
                        this.state = State.INSIDE;
                    }
                } else {
                    this.state = State.INSIDE;
                }
            }
            return this.checkRightBound(newDepth, transition);
        }

        private int markDone() {
            this.state = State.AFTER_RIGHT;
            return -1;
        }

        private int checkRightBound(int newDepth, int transition) {
            if (newDepth > this.rightNextDepth) {
                return newDepth;
            }
            if (newDepth < this.rightNextDepth) {
                return this.markDone();
            }
            if (transition < this.rightNext) {
                return newDepth;
            }
            if (transition > this.rightNext) {
                return this.markDone();
            }
            this.rightNext = this.right.next();
            ++this.rightNextDepth;
            if (this.rightNext == -1 && this.excludeRight) {
                return this.markDone();
            }
            return newDepth;
        }

        @Override
        public int advanceMultiple(Trie.TransitionsReceiver receiver) {
            switch (this.state) {
                case BEFORE_LEFT: {
                    return this.advance();
                }
                case INSIDE: {
                    int depth = this.source.depth();
                    if (depth == this.rightNextDepth - 1) {
                        return this.advance();
                    }
                    int newDepth = this.source.advanceMultiple(receiver);
                    if (newDepth > depth) {
                        return newDepth;
                    }
                    return this.checkRightBound(newDepth, this.source.incomingTransition());
                }
            }
            throw new AssertionError();
        }

        @Override
        public int skipChildren() {
            assert (this.state != State.AFTER_RIGHT);
            this.state = State.INSIDE;
            return this.checkRightBound(this.source.skipChildren(), this.source.incomingTransition());
        }

        @Override
        public int depth() {
            return this.state == State.AFTER_RIGHT ? -1 : this.source.depth();
        }

        @Override
        public int incomingTransition() {
            return this.source.incomingTransition();
        }

        @Override
        public T content() {
            return this.state == State.INSIDE ? (T)this.source.content() : null;
        }
    }

    private static enum State {
        BEFORE_LEFT,
        INSIDE,
        AFTER_RIGHT;

    }
}

