/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IVerifier;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReadsListener;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReaderWithFilter;
import org.apache.cassandra.io.sstable.format.bti.BtiTableScanner;
import org.apache.cassandra.io.sstable.format.bti.BtiTableVerifier;
import org.apache.cassandra.io.sstable.format.bti.PartitionIndex;
import org.apache.cassandra.io.sstable.format.bti.PartitionIndexEarly;
import org.apache.cassandra.io.sstable.format.bti.PartitionIterator;
import org.apache.cassandra.io.sstable.format.bti.SSTableIterator;
import org.apache.cassandra.io.sstable.format.bti.SSTableReversedIterator;
import org.apache.cassandra.io.sstable.format.bti.ScrubIterator;
import org.apache.cassandra.io.sstable.format.bti.ScrubPartitionIterator;
import org.apache.cassandra.io.sstable.format.bti.TrieIndexEntry;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.concurrent.SharedCloseable;

public class BtiTableReader
extends SSTableReaderWithFilter {
    private final FileHandle rowIndexFile;
    private final PartitionIndex partitionIndex;

    public BtiTableReader(Builder builder, SSTable.Owner owner) {
        super(builder, owner);
        this.rowIndexFile = builder.getRowIndexFile();
        this.partitionIndex = builder.getPartitionIndex();
    }

    protected final Builder unbuildTo(Builder builder, boolean sharedCopy) {
        Builder b = super.unbuildTo(builder, sharedCopy);
        if (builder.getPartitionIndex() == null) {
            b.setPartitionIndex(sharedCopy ? SharedCloseable.sharedCopyOrNull(this.partitionIndex) : this.partitionIndex);
        }
        if (builder.getRowIndexFile() == null) {
            b.setRowIndexFile(sharedCopy ? SharedCloseable.sharedCopyOrNull(this.rowIndexFile) : this.rowIndexFile);
        }
        return b;
    }

    @Override
    protected List<AutoCloseable> setupInstance(boolean trackHotness) {
        ArrayList closeables = Lists.newArrayList((Object[])new AutoCloseable[]{this.rowIndexFile, this.partitionIndex});
        closeables.addAll(super.setupInstance(trackHotness));
        return closeables;
    }

    protected boolean filterFirst() {
        return this.openReason == SSTableReader.OpenReason.MOVED_START;
    }

    protected boolean filterLast() {
        return this.openReason == SSTableReader.OpenReason.EARLY && this.partitionIndex instanceof PartitionIndexEarly;
    }

    @Override
    public long estimatedKeys() {
        return this.partitionIndex == null ? 0L : this.partitionIndex.size();
    }

    @Override
    protected TrieIndexEntry getRowIndexEntry(PartitionPosition key, SSTableReader.Operator operator, boolean updateStats, SSTableReadsListener listener) {
        if (operator == SSTableReader.Operator.EQ) {
            return this.getExactPosition((DecoratedKey)key, listener, updateStats);
        }
        if (operator == SSTableReader.Operator.GT || operator == SSTableReader.Operator.GE) {
            TrieIndexEntry trieIndexEntry;
            block13: {
                if (this.filterLast() && this.getLast().compareTo(key) < 0) {
                    this.notifySkipped(SSTableReadsListener.SkippingReason.MIN_MAX_KEYS, listener, operator, updateStats);
                    return null;
                }
                boolean filteredLeft = this.filterFirst() && this.getFirst().compareTo(key) > 0;
                PartitionPosition searchKey = filteredLeft ? this.getFirst() : key;
                SSTableReader.Operator searchOp = filteredLeft ? SSTableReader.Operator.GE : operator;
                PartitionIndex.Reader reader = this.partitionIndex.openReader();
                try {
                    TrieIndexEntry rie = reader.ceiling(searchKey, (pos, assumeNoMatch, compareKey) -> this.retrieveEntryIfAcceptable(searchOp, (PartitionPosition)compareKey, pos, assumeNoMatch));
                    if (rie != null) {
                        this.notifySelected(SSTableReadsListener.SelectionReason.INDEX_ENTRY_FOUND, listener, operator, updateStats, rie);
                    } else {
                        this.notifySkipped(SSTableReadsListener.SkippingReason.INDEX_ENTRY_NOT_FOUND, listener, operator, updateStats);
                    }
                    trieIndexEntry = rie;
                    if (reader == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.markSuspect();
                        throw new CorruptSSTableException((Throwable)e, this.rowIndexFile.path());
                    }
                }
                reader.close();
            }
            return trieIndexEntry;
        }
        throw new IllegalArgumentException("Invalid op: " + operator);
    }

    private TrieIndexEntry retrieveEntryIfAcceptable(SSTableReader.Operator searchOp, PartitionPosition searchKey, long pos, boolean assumeNoMatch) throws IOException {
        if (pos >= 0L) {
            try (FileDataInput in = this.rowIndexFile.createReader(pos);){
                Object indexKey;
                if (assumeNoMatch) {
                    ByteBufferUtil.skipShortLength(in);
                } else {
                    indexKey = ByteBufferUtil.readWithShortLength(in);
                    DecoratedKey decorated = this.decorateKey((ByteBuffer)indexKey);
                    if (searchOp.apply(decorated.compareTo(searchKey)) != 0) {
                        TrieIndexEntry trieIndexEntry = null;
                        return trieIndexEntry;
                    }
                }
                indexKey = TrieIndexEntry.deserialize(in, in.getFilePointer(), this.descriptor.version);
                return indexKey;
            }
        }
        pos ^= 0xFFFFFFFFFFFFFFFFL;
        if (!assumeNoMatch) {
            try (FileDataInput in = this.dfile.createReader(pos);){
                ByteBuffer indexKey = ByteBufferUtil.readWithShortLength(in);
                DecoratedKey decorated = this.decorateKey(indexKey);
                if (searchOp.apply(decorated.compareTo(searchKey)) != 0) {
                    TrieIndexEntry trieIndexEntry = null;
                    return trieIndexEntry;
                }
            }
        }
        return new TrieIndexEntry(pos);
    }

    @Override
    public DecoratedKey keyAtPositionFromSecondaryIndex(long keyPositionFromSecondaryIndex) throws IOException {
        try (RandomAccessReader reader = this.openDataReader();){
            reader.seek(keyPositionFromSecondaryIndex);
            if (reader.isEOF()) {
                DecoratedKey decoratedKey = null;
                return decoratedKey;
            }
            DecoratedKey decoratedKey = this.decorateKey(ByteBufferUtil.readWithShortLength(reader));
            return decoratedKey;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    TrieIndexEntry getExactPosition(DecoratedKey dk, SSTableReadsListener listener, boolean updateStats) {
        if (this.filterFirst() && this.getFirst().compareTo(dk) > 0 || this.filterLast() && this.getLast().compareTo(dk) < 0) {
            this.notifySkipped(SSTableReadsListener.SkippingReason.MIN_MAX_KEYS, listener, SSTableReader.Operator.EQ, updateStats);
            return null;
        }
        if (!this.isPresentInFilter(dk)) {
            this.notifySkipped(SSTableReadsListener.SkippingReason.BLOOM_FILTER, listener, SSTableReader.Operator.EQ, updateStats);
            return null;
        }
        try (PartitionIndex.Reader reader = this.partitionIndex.openReader();){
            TrieIndexEntry trieIndexEntry;
            block24: {
                FileDataInput in;
                block22: {
                    TrieIndexEntry trieIndexEntry2;
                    block23: {
                        long seekPosition;
                        FileHandle fh;
                        long indexPos = reader.exactCandidate(dk);
                        if (indexPos == Long.MIN_VALUE) {
                            this.notifySkipped(SSTableReadsListener.SkippingReason.PARTITION_INDEX_LOOKUP, listener, SSTableReader.Operator.EQ, updateStats);
                            TrieIndexEntry trieIndexEntry3 = null;
                            return trieIndexEntry3;
                        }
                        if (indexPos >= 0L) {
                            fh = this.rowIndexFile;
                            seekPosition = indexPos;
                        } else {
                            fh = this.dfile;
                            seekPosition = indexPos ^ 0xFFFFFFFFFFFFFFFFL;
                        }
                        in = fh.createReader(seekPosition);
                        try {
                            if (!ByteBufferUtil.equalsWithShortLength(in, dk.getKey())) break block22;
                            TrieIndexEntry rie = indexPos >= 0L ? TrieIndexEntry.deserialize(in, in.getFilePointer(), this.descriptor.version) : new TrieIndexEntry(indexPos ^ 0xFFFFFFFFFFFFFFFFL);
                            this.notifySelected(SSTableReadsListener.SelectionReason.INDEX_ENTRY_FOUND, listener, SSTableReader.Operator.EQ, updateStats, rie);
                            trieIndexEntry2 = rie;
                            if (in == null) break block23;
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        in.close();
                    }
                    return trieIndexEntry2;
                }
                this.notifySkipped(SSTableReadsListener.SkippingReason.INDEX_ENTRY_NOT_FOUND, listener, SSTableReader.Operator.EQ, updateStats);
                trieIndexEntry = null;
                if (in == null) break block24;
                in.close();
            }
            return trieIndexEntry;
        }
        catch (IOException | ArrayIndexOutOfBoundsException | AssertionError | IllegalArgumentException e) {
            this.markSuspect();
            throw new CorruptSSTableException((Throwable)e, this.rowIndexFile.path());
        }
    }

    PartitionIterator coveredKeysIterator(AbstractBounds<PartitionPosition> bounds) throws IOException {
        return PartitionIterator.create(this.partitionIndex, this.metadata().partitioner, this.rowIndexFile, this.dfile, (PartitionPosition)bounds.left, bounds.inclusiveLeft() ? -1 : 0, (PartitionPosition)bounds.right, bounds.inclusiveRight() ? 0 : -1, this.descriptor.version);
    }

    public ScrubPartitionIterator scrubPartitionsIterator() throws IOException {
        return new ScrubIterator(this.partitionIndex, this.rowIndexFile, this.descriptor.version);
    }

    @Override
    public PartitionIterator keyReader() throws IOException {
        return PartitionIterator.create(this.partitionIndex, this.metadata().partitioner, this.rowIndexFile, this.dfile, this.descriptor.version);
    }

    @Override
    public Iterable<DecoratedKey> getKeySamples(Range<Token> range) {
        return Collections.emptyList();
    }

    @Override
    public long estimatedKeysForRanges(Collection<Range<Token>> ranges) {
        long selectedDataSize = 0L;
        for (Range range : Range.normalize(ranges)) {
            PartitionPosition left = ((Token)range.left).minKeyBound();
            if (left.compareTo(this.getFirst()) <= 0) {
                left = null;
            } else if (left.compareTo(this.getLast()) > 0) continue;
            PartitionPosition right = ((Token)range.right).minKeyBound();
            if (((Token)range.right).isMinimum() || right.compareTo(this.getLast()) >= 0) {
                right = null;
            } else if (right.compareTo(this.getFirst()) < 0) continue;
            if (left == null && right == null) {
                return this.partitionIndex.size();
            }
            if (left == null && this.filterFirst()) {
                left = this.getFirst();
            }
            if (right == null && this.filterLast()) {
                right = this.getLast();
            }
            long startPos = left != null ? this.getPosition(left, SSTableReader.Operator.GE) : 0L;
            long endPos = right != null ? this.getPosition(right, SSTableReader.Operator.GE) : this.uncompressedLength();
            selectedDataSize += endPos - startPos;
        }
        return Math.round((double)selectedDataSize / this.sstableMetadata.estimatedPartitionSize.rawMean());
    }

    @Override
    public UnfilteredRowIterator rowIterator(DecoratedKey key, Slices slices, ColumnFilter selectedColumns, boolean reversed, SSTableReadsListener listener) {
        return this.rowIterator(null, key, this.getExactPosition(key, listener, true), slices, selectedColumns, reversed);
    }

    public UnfilteredRowIterator rowIterator(FileDataInput dataFileInput, DecoratedKey key, TrieIndexEntry indexEntry, Slices slices, ColumnFilter selectedColumns, boolean reversed) {
        if (indexEntry == null) {
            return UnfilteredRowIterators.noRowsIterator(this.metadata(), key, Rows.EMPTY_STATIC_ROW, DeletionTime.LIVE, reversed);
        }
        if (reversed) {
            return new SSTableReversedIterator(this, dataFileInput, key, indexEntry, slices, selectedColumns, this.rowIndexFile);
        }
        return new SSTableIterator(this, dataFileInput, key, indexEntry, slices, selectedColumns, this.rowIndexFile);
    }

    @Override
    @VisibleForTesting
    public BtiTableReader cloneAndReplace(IFilter filter) {
        return (BtiTableReader)this.unbuildTo((Builder)new Builder(this.descriptor).setFilter(filter), true).build(this.owner().orElse(null), true, true);
    }

    @Override
    public BtiTableReader cloneWithRestoredStart(DecoratedKey restoredStart) {
        return this.runWithLock(ignored -> this.cloneAndReplace(restoredStart, SSTableReader.OpenReason.NORMAL));
    }

    @Override
    public BtiTableReader cloneWithNewStart(DecoratedKey newStart) {
        return this.runWithLock(d -> {
            assert (this.openReason != SSTableReader.OpenReason.EARLY) : "Cannot open early an early-open SSTable";
            if (newStart.compareTo(this.getFirst()) > 0) {
                long dataStart = this.getPosition(newStart, SSTableReader.Operator.EQ);
                this.runOnClose(() -> this.dfile.dropPageCache(dataStart));
            }
            return this.cloneAndReplace(newStart, SSTableReader.OpenReason.MOVED_START);
        });
    }

    private BtiTableReader cloneAndReplace(DecoratedKey newFirst, SSTableReader.OpenReason reason) {
        return (BtiTableReader)((Builder)((Builder)this.unbuildTo(new Builder(this.descriptor), true).setFirst(newFirst)).setOpenReason(reason)).build(this.owner().orElse(null), true, true);
    }

    @Override
    public DecoratedKey firstKeyBeyond(PartitionPosition token) {
        DecoratedKey decoratedKey;
        block9: {
            TrieIndexEntry pos = this.getRowIndexEntry(token, SSTableReader.Operator.GT, true, SSTableReadsListener.NOOP_LISTENER);
            if (pos == null) {
                return null;
            }
            FileDataInput in = this.dfile.createReader(pos.position);
            try {
                ByteBuffer indexKey = ByteBufferUtil.readWithShortLength(in);
                decoratedKey = this.decorateKey(indexKey);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.markSuspect();
                    throw new CorruptSSTableException((Throwable)e, this.dfile.path());
                }
            }
            in.close();
        }
        return decoratedKey;
    }

    @Override
    public void releaseInMemoryComponents() {
        this.closeInternalComponent(this.partitionIndex);
    }

    @Override
    public boolean isEstimationInformative() {
        return true;
    }

    @Override
    public UnfilteredPartitionIterator partitionIterator(ColumnFilter columnFilter, DataRange dataRange, SSTableReadsListener listener) {
        return BtiTableScanner.getScanner(this, columnFilter, dataRange, listener);
    }

    @Override
    public IVerifier getVerifier(ColumnFamilyStore cfs, OutputHandler outputHandler, boolean isOffline, IVerifier.Options options) {
        Preconditions.checkArgument((boolean)cfs.metadata().equals(this.metadata()));
        return new BtiTableVerifier(cfs, this, outputHandler, isOffline, options);
    }

    public static class Builder
    extends SSTableReaderWithFilter.Builder<BtiTableReader, Builder> {
        private PartitionIndex partitionIndex;
        private FileHandle rowIndexFile;

        public Builder(Descriptor descriptor) {
            super(descriptor);
        }

        public Builder setRowIndexFile(FileHandle rowIndexFile) {
            this.rowIndexFile = rowIndexFile;
            return this;
        }

        public Builder setPartitionIndex(PartitionIndex partitionIndex) {
            this.partitionIndex = partitionIndex;
            return this;
        }

        public PartitionIndex getPartitionIndex() {
            return this.partitionIndex;
        }

        public FileHandle getRowIndexFile() {
            return this.rowIndexFile;
        }

        @Override
        protected BtiTableReader buildInternal(SSTable.Owner owner) {
            return new BtiTableReader(this, owner);
        }
    }
}

