/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import com.google.common.base.Preconditions;
import io.airlift.airline.UsageHelper;
import io.airlift.airline.UsagePrinter;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nullable;

public class CommandGroupUsage {
    private final int columnSize;
    private final boolean hideGlobalOptions;
    private final Comparator<? super OptionMetadata> optionComparator;
    private final Comparator<? super CommandMetadata> commandComparator = UsageHelper.DEFAULT_COMMAND_COMPARATOR;

    public CommandGroupUsage() {
        this(79, false, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CommandGroupUsage(int columnSize) {
        this(columnSize, false, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CommandGroupUsage(int columnSize, boolean hideGlobalOptions) {
        this(columnSize, hideGlobalOptions, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CommandGroupUsage(int columnSize, boolean hideGlobalOptions, @Nullable Comparator<? super OptionMetadata> optionComparator) {
        Preconditions.checkArgument(columnSize > 0, "columnSize must be greater than 0");
        this.columnSize = columnSize;
        this.hideGlobalOptions = hideGlobalOptions;
        this.optionComparator = optionComparator;
    }

    public void usage(@Nullable GlobalMetadata global, CommandGroupMetadata group) {
        StringBuilder stringBuilder = new StringBuilder();
        this.usage(global, group, stringBuilder);
        System.out.println(stringBuilder.toString());
    }

    public void usage(@Nullable GlobalMetadata global, CommandGroupMetadata group, StringBuilder out) {
        this.usage(global, group, new UsagePrinter(out, this.columnSize));
    }

    public void usage(@Nullable GlobalMetadata global, CommandGroupMetadata group, UsagePrinter out) {
        UsagePrinter descriptionPrinter;
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(global.getName()).append(group.getName()).append("-").append(group.getDescription()).newline().newline();
        out.append("SYNOPSIS").newline();
        UsagePrinter synopsis = out.newIndentedPrinter(8).newPrinterWithHangingIndent(8);
        ArrayList<CommandMetadata> commands = new ArrayList<CommandMetadata>(group.getCommands());
        Collections.sort(commands, this.commandComparator);
        if (group.getDefaultCommand() != null) {
            CommandMetadata command = group.getDefaultCommand();
            if (global != null) {
                synopsis.append(global.getName());
                if (!this.hideGlobalOptions) {
                    synopsis.appendWords(UsageHelper.toSynopsisUsage(command.getGlobalOptions()));
                }
            }
            synopsis.append(group.getName()).appendWords(UsageHelper.toSynopsisUsage(command.getGroupOptions()));
            synopsis.newline();
        }
        for (CommandMetadata commandMetadata : commands) {
            if (global != null) {
                synopsis.append(global.getName());
                if (!this.hideGlobalOptions) {
                    synopsis.appendWords(UsageHelper.toSynopsisUsage(commandMetadata.getGlobalOptions()));
                }
            }
            synopsis.append(group.getName()).appendWords(UsageHelper.toSynopsisUsage(commandMetadata.getGroupOptions()));
            synopsis.append(commandMetadata.getName()).appendWords(UsageHelper.toSynopsisUsage(commandMetadata.getCommandOptions()));
            synopsis.newline();
        }
        synopsis.newline();
        ArrayList<OptionMetadata> options = new ArrayList<OptionMetadata>();
        options.addAll(group.getOptions());
        if (global != null && !this.hideGlobalOptions) {
            options.addAll(global.getOptions());
        }
        if (options.size() > 0) {
            if (this.optionComparator != null) {
                Collections.sort(options, this.optionComparator);
            }
            out.append("OPTIONS").newline();
            for (OptionMetadata option : options) {
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append(UsageHelper.toDescription(option)).newline();
                descriptionPrinter = optionPrinter.newIndentedPrinter(4);
                descriptionPrinter.append(option.getDescription()).newline();
                descriptionPrinter.newline();
            }
        }
        if (commands.size() > 0 || group.getDefaultCommand() != null) {
            out.append("COMMANDS").newline();
            UsagePrinter usagePrinter = out.newIndentedPrinter(8);
            if (group.getDefaultCommand() != null && group.getDefaultCommand().getDescription() != null) {
                usagePrinter.append("With no arguments,").append(group.getDefaultCommand().getDescription()).newline().newline();
            }
            for (CommandMetadata command : group.getCommands()) {
                usagePrinter.append(command.getName()).newline();
                descriptionPrinter = usagePrinter.newIndentedPrinter(4);
                descriptionPrinter.append(command.getDescription()).newline().newline();
                for (OptionMetadata option : command.getCommandOptions()) {
                    if (option.isHidden() || option.getDescription() == null) continue;
                    descriptionPrinter.append("With").append(CommandGroupUsage.longest(option.getOptions())).append("option,").append(option.getDescription()).newline().newline();
                }
            }
        }
    }

    private static String longest(Iterable<String> iterable) {
        String longest = "";
        for (String value : iterable) {
            if (value.length() <= longest.length()) continue;
            longest = value;
        }
        return longest;
    }
}

