/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.apache.cassandra.cql3.CqlLexer;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.ErrorCollector;
import org.apache.cassandra.exceptions.SyntaxException;

public final class CQLFragmentParser {
    public static <R> R parseAny(CQLParserFunction<R> parserFunction, String input, String meaning) {
        try {
            return CQLFragmentParser.parseAnyUnhandled(parserFunction, input);
        }
        catch (RuntimeException re) {
            throw new SyntaxException(String.format("Failed parsing %s: [%s] reason: %s %s", meaning, input, re.getClass().getSimpleName(), re.getMessage()));
        }
        catch (RecognitionException e) {
            throw new SyntaxException("Invalid or malformed " + meaning + ": " + e.getMessage());
        }
    }

    public static <R> R parseAnyUnhandled(CQLParserFunction<R> parserFunction, String input) throws RecognitionException {
        ErrorCollector errorCollector = new ErrorCollector(input);
        ANTLRStringStream stream = new ANTLRStringStream(input);
        CqlLexer lexer = new CqlLexer(stream);
        lexer.addErrorListener(errorCollector);
        CommonTokenStream tokenStream = new CommonTokenStream(lexer);
        CqlParser parser = new CqlParser(tokenStream);
        parser.addErrorListener(errorCollector);
        R r = parserFunction.parse(parser);
        errorCollector.throwFirstSyntaxError();
        return r;
    }

    @FunctionalInterface
    public static interface CQLParserFunction<R> {
        public R parse(CqlParser var1) throws RecognitionException;
    }
}

