/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.internal;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.UUIDGen;

public class CollatedViewIndexBuilder
extends SecondaryIndexBuilder
implements AutoCloseable {
    private final ColumnFamilyStore cfs;
    private final Set<Index> indexers;
    private final ReducingKeyIterator iter;
    private final UUID compactionId;
    private final Collection<SSTableReader> sstables;

    public CollatedViewIndexBuilder(ColumnFamilyStore cfs, Set<Index> indexers, ReducingKeyIterator iter2, Collection<SSTableReader> sstables) {
        this.cfs = cfs;
        this.indexers = indexers;
        this.iter = iter2;
        this.compactionId = UUIDGen.getTimeUUID();
        this.sstables = sstables;
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.cfs.metadata(), OperationType.INDEX_BUILD, this.iter.getBytesRead(), this.iter.getTotalBytes(), this.compactionId, this.sstables);
    }

    @Override
    public void build() {
        int pageSize = this.cfs.indexManager.calculateIndexingPageSize();
        while (this.iter.hasNext()) {
            if (this.isStopRequested()) {
                throw new CompactionInterruptedException(this.getCompactionInfo());
            }
            DecoratedKey key = this.iter.next();
            this.cfs.indexManager.indexPartition(key, this.indexers, pageSize);
        }
    }

    @Override
    public void close() {
        this.iter.close();
    }
}

