/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.UUIDSerializer;

public class FinalizePropose
extends RepairMessage {
    public final UUID sessionID;
    public static final IVersionedSerializer<FinalizePropose> serializer = new IVersionedSerializer<FinalizePropose>(){

        @Override
        public void serialize(FinalizePropose msg, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(msg.sessionID, out, version);
        }

        @Override
        public FinalizePropose deserialize(DataInputPlus in, int version) throws IOException {
            return new FinalizePropose(UUIDSerializer.serializer.deserialize(in, version));
        }

        @Override
        public long serializedSize(FinalizePropose msg, int version) {
            return UUIDSerializer.serializer.serializedSize(msg.sessionID, version);
        }
    };

    public FinalizePropose(UUID sessionID) {
        super(null);
        assert (sessionID != null);
        this.sessionID = sessionID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinalizePropose that = (FinalizePropose)o;
        return this.sessionID.equals(that.sessionID);
    }

    public int hashCode() {
        return this.sessionID.hashCode();
    }

    public String toString() {
        return "FinalizePropose{sessionID=" + this.sessionID + '}';
    }
}

