/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader.common;

import java.io.EOFException;
import java.io.IOException;
import org.apache.cassandra.spark.reader.common.BigLongArray;

public abstract class AbstractCompressionMetadata {
    protected final long dataLength;
    protected final BigLongArray chunkOffsets;

    protected AbstractCompressionMetadata(long dataLength, BigLongArray chunkOffsets) {
        this.dataLength = dataLength;
        this.chunkOffsets = chunkOffsets;
    }

    protected abstract int chunkLength();

    protected abstract double crcCheckChance();

    public long getDataLength() {
        return this.dataLength;
    }

    public Chunk chunkAtIndex(int index) {
        long chunkOffset = this.chunkOffsets.get(index);
        long nextChunkOffset = index + 1 == this.chunkOffsets.size ? -1L : this.chunkOffsets.get(index + 1);
        return new Chunk(chunkOffset, nextChunkOffset == -1L ? -1 : (int)(nextChunkOffset - chunkOffset - 4L));
    }

    public int chunkIdx(long position) {
        return (int)(position / (long)this.chunkLength());
    }

    public Chunk chunkAtPosition(long position) throws IOException {
        int index = this.chunkIdx(position);
        if (index >= this.chunkOffsets.size) {
            throw new EOFException();
        }
        return this.chunkAtIndex(index);
    }

    public static class Chunk {
        public final long offset;
        public int length;

        public Chunk(long offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String toString() {
            return String.format("Chunk<offset: %d, length: %d>", this.offset, this.length);
        }
    }
}

