/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter.types;

import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.converter.types.SparkType;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;

public class SparkDouble
implements SparkType {
    public static final SparkDouble INSTANCE = new SparkDouble();

    private SparkDouble() {
    }

    @Override
    public DataType dataType(BigNumberConfig bigNumberConfig) {
        return DataTypes.DoubleType;
    }

    @Override
    public Object nativeSparkSqlRowValue(GenericInternalRow row, int position) {
        return row.getDouble(position);
    }

    @Override
    public Object nativeSparkSqlRowValue(Row row, int position) {
        return row.getDouble(position);
    }

    @Override
    public int compareTo(Object first, Object second) {
        return CqlField.DOUBLE_COMPARATOR.compare((Double)first, (Double)second);
    }
}

