/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter.types;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.cassandra.spark.data.converter.types.BinaryFeatures;
import org.jetbrains.annotations.NotNull;

public class SparkInet
implements BinaryFeatures {
    public static final SparkInet INSTANCE = new SparkInet();

    private SparkInet() {
    }

    @Override
    public Object toSparkSqlType(@NotNull Object value, boolean isFrozen) {
        return ((InetAddress)value).getAddress();
    }

    @Override
    public Object toTestRowType(Object value) {
        if (value instanceof byte[]) {
            try {
                return InetAddress.getByAddress((byte[])value);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return value;
    }
}

