/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter.types.complex;

import java.nio.ByteBuffer;
import java.util.stream.IntStream;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.converter.SparkSqlTypeConverter;
import org.apache.cassandra.spark.data.converter.types.SparkType;
import org.apache.cassandra.spark.data.converter.types.complex.CollectionFeatures;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;

public class SparkTuple
implements CollectionFeatures {
    private final SparkSqlTypeConverter converter;
    private final CqlField.CqlTuple tuple;

    public SparkTuple(SparkSqlTypeConverter converter, CqlField.CqlTuple tuple) {
        this.converter = converter;
        this.tuple = tuple;
    }

    @Override
    public DataType dataType(BigNumberConfig bigNumberConfig) {
        return DataTypes.createStructType((StructField[])((StructField[])IntStream.range(0, this.size()).mapToObj(index -> DataTypes.createStructField((String)Integer.toString(index), (DataType)this.sparkType(index).dataType(bigNumberConfig), (boolean)true)).toArray(StructField[]::new)));
    }

    @Override
    public CqlField.CqlCollection collection() {
        return this.tuple;
    }

    @Override
    public SparkSqlTypeConverter converter() {
        return this.converter;
    }

    @Override
    public Object toSparkSqlType(Object value, boolean isFrozen) {
        if (value instanceof ByteBuffer) {
            return this.toSparkSqlType(this.tuple.deserializeToJavaType((ByteBuffer)value), isFrozen);
        }
        if (!(value instanceof Object[])) {
            throw new IllegalArgumentException("Expected Object[] or raw ByteBuffer for Tuple type");
        }
        Object[] array = (Object[])value;
        for (int index = 0; index < array.length; ++index) {
            array[index] = array[index] == null ? null : this.sparkType(index).toSparkSqlType(array[index], isFrozen);
        }
        return new GenericInternalRow(array);
    }

    @Override
    public Object sparkSqlRowValue(GenericInternalRow row, int position) {
        InternalRow tupleStruct = row.getStruct(position, this.size());
        return IntStream.range(0, this.size()).boxed().map(index -> this.sparkType((int)index).toTestRowType(tupleStruct.get(index.intValue(), this.sparkType((int)index).dataType()))).toArray();
    }

    @Override
    public Object sparkSqlRowValue(Row row, int position) {
        Row tupleStruct = row.getStruct(position);
        return IntStream.range(0, tupleStruct.size()).boxed().filter(index -> !tupleStruct.isNullAt(index.intValue())).map(index -> this.sparkType((int)index).toTestRowType(tupleStruct.get(index.intValue()))).toArray();
    }

    @Override
    public Object toTestRowType(Object value) {
        GenericRowWithSchema tupleRow = (GenericRowWithSchema)value;
        Object[] tupleResult = new Object[tupleRow.size()];
        for (int index = 0; index < tupleRow.size(); ++index) {
            tupleResult[index] = this.sparkType(index).toTestRowType(tupleRow.get(index));
        }
        return tupleResult;
    }

    @Override
    public boolean equalsTo(Object first, Object second) {
        return SparkType.equalsArrays(((GenericInternalRow)first).values(), ((GenericInternalRow)second).values(), this::sparkType);
    }

    @Override
    public int compareTo(Object first, Object second) {
        return SparkType.compareArrays(((GenericInternalRow)first).values(), ((GenericInternalRow)second).values(), this::sparkType);
    }
}

