/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.types;

import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.function.Function;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.spark.data.types.AbstractTimeUUID;
import org.apache.cassandra.utils.TimeUUID;

public class TimeUUID
extends AbstractTimeUUID {
    public static final TimeUUID INSTANCE = new TimeUUID();

    @Override
    public Object randomValue(int minCollectionSize) {
        return TimeUUID.Generator.nextTimeUUID().asUUID();
    }

    @Override
    public <T> TypeSerializer<T> serializer() {
        return AnalyticsTimeUUIDSerializer.INSTANCE;
    }

    private static class AnalyticsTimeUUIDSerializer
    extends TypeSerializer<UUID> {
        private static final AnalyticsTimeUUIDSerializer INSTANCE = new AnalyticsTimeUUIDSerializer();

        private AnalyticsTimeUUIDSerializer() {
        }

        public ByteBuffer serialize(UUID value) {
            org.apache.cassandra.utils.TimeUUID timeUuid = AnalyticsTimeUUIDSerializer.nullOrConvert(value, org.apache.cassandra.utils.TimeUUID::fromUuid);
            return TimeUUID.Serializer.instance.serialize(timeUuid);
        }

        public <V> UUID deserialize(V v, ValueAccessor<V> valueAccessor) {
            org.apache.cassandra.utils.TimeUUID timeUuid = TimeUUID.Serializer.instance.deserialize(v, valueAccessor);
            return AnalyticsTimeUUIDSerializer.nullOrConvert(timeUuid, org.apache.cassandra.utils.TimeUUID::asUUID);
        }

        public <V> void validate(V v, ValueAccessor<V> valueAccessor) throws MarshalException {
            TimeUUID.Serializer.instance.validate(v, valueAccessor);
        }

        public String toString(UUID uuid) {
            return uuid == null ? "" : uuid.toString();
        }

        public Class<UUID> getType() {
            return UUID.class;
        }

        private static <I, O> O nullOrConvert(I input, Function<I, O> converter) {
            if (input == null) {
                return null;
            }
            return converter.apply(input);
        }
    }
}

