/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Map;
import org.apache.cassandra.spark.bulkwriter.CassandraContext;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.WriteAvailability;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.exception.SidecarApiCallException;
import org.apache.cassandra.spark.exception.TimeSkewTooLargeException;
import org.apache.cassandra.spark.validation.StartupValidatable;
import org.jetbrains.annotations.Nullable;

public interface ClusterInfo
extends StartupValidatable {
    public void refreshClusterInfo();

    public TokenRangeMapping<RingInstance> getTokenRangeMapping(boolean var1);

    public String getLowestCassandraVersion();

    public Map<RingInstance, WriteAvailability> clusterWriteAvailability();

    public Partitioner getPartitioner();

    public void checkBulkWriterIsEnabledOrThrow();

    public void validateTimeSkew(Range<BigInteger> var1) throws SidecarApiCallException, TimeSkewTooLargeException;

    public String getKeyspaceSchema(boolean var1);

    public ReplicationFactor replicationFactor();

    public CassandraContext getCassandraContext();

    @Nullable
    default public String clusterId() {
        return null;
    }

    default public void close() {
    }
}

