/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import o.a.c.sidecar.client.shaded.client.HttpResponse;
import o.a.c.sidecar.client.shaded.client.HttpResponseImpl;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.client.retry.RetryAction;
import o.a.c.sidecar.client.shaded.client.retry.RetryPolicy;
import o.a.c.sidecar.client.shaded.common.request.CreateRestoreJobSliceRequest;
import o.a.c.sidecar.client.shaded.common.request.Request;
import o.a.c.sidecar.client.shaded.common.request.data.CreateRestoreJobRequestPayload;
import o.a.c.sidecar.client.shaded.common.request.data.CreateSliceRequestPayload;
import o.a.c.sidecar.client.shaded.common.request.data.UpdateRestoreJobRequestPayload;
import o.a.c.sidecar.client.shaded.common.response.data.RestoreJobSummaryResponsePayload;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.Bundle;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleStorageObject;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.StorageClient;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.exception.S3ApiCallException;
import org.apache.cassandra.spark.exception.SidecarApiCallException;
import org.apache.cassandra.spark.transports.storage.StorageCredentials;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudStorageDataTransferApiImpl
implements CloudStorageDataTransferApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudStorageDataTransferApiImpl.class);
    @Nullable
    private final String clusterId;
    private final JobInfo jobInfo;
    private final SidecarClient sidecarClient;
    private final StorageClient storageClient;

    public CloudStorageDataTransferApiImpl(JobInfo jobInfo, SidecarClient sidecarClient, StorageClient storageClient, @Nullable String clusterId) {
        this.jobInfo = jobInfo;
        this.sidecarClient = sidecarClient;
        this.storageClient = storageClient;
        this.clusterId = clusterId;
    }

    public JobInfo jobInfo() {
        return this.jobInfo;
    }

    public SidecarClient sidecarClient() {
        return this.sidecarClient;
    }

    @Override
    public BundleStorageObject uploadBundle(StorageCredentials writeCredentials, Bundle bundle) throws S3ApiCallException {
        try {
            return this.storageClient.multiPartUpload(writeCredentials, bundle);
        }
        catch (Exception exception) {
            this.handleInterruption(exception);
            throw new S3ApiCallException("Failed to upload bundles to S3", (Throwable)exception);
        }
    }

    @Override
    public void createRestoreJob(CreateRestoreJobRequestPayload createRestoreJobRequestPayload) throws SidecarApiCallException {
        UUID jobId = this.jobInfo.getRestoreJobId(this.clusterId);
        try {
            QualifiedTableName qualifiedTableName = this.jobInfo.qualifiedTableName();
            this.sidecarClient.createRestoreJob(qualifiedTableName.keyspace(), qualifiedTableName.table(), createRestoreJobRequestPayload).get();
        }
        catch (Exception exception) {
            this.handleInterruption(exception);
            throw new SidecarApiCallException("Failed to create a new restore job. restoreJobId=" + String.valueOf(jobId), (Throwable)exception);
        }
    }

    @Override
    public RestoreJobSummaryResponsePayload restoreJobSummary() throws SidecarApiCallException {
        UUID jobId = this.jobInfo.getRestoreJobId(this.clusterId);
        try {
            QualifiedTableName qualifiedTableName = this.jobInfo.qualifiedTableName();
            return (RestoreJobSummaryResponsePayload)this.sidecarClient.restoreJobSummary(qualifiedTableName.keyspace(), qualifiedTableName.table(), jobId).get();
        }
        catch (Exception exception) {
            this.handleInterruption(exception);
            throw new SidecarApiCallException("Failed to retrieve restore job summary. restoreJobId=" + String.valueOf(jobId), (Throwable)exception);
        }
    }

    @Override
    public void createRestoreSliceFromExecutor(SidecarInstance sidecarInstance, CreateSliceRequestPayload createSliceRequestPayload) throws SidecarApiCallException {
        UUID jobId = this.jobInfo.getRestoreJobId(this.clusterId);
        try {
            this.createRestoreSliceWithCustomRetry(sidecarInstance, createSliceRequestPayload, new ExecutorCreateSliceRetryPolicy(this.sidecarClient)).get();
        }
        catch (Exception exception) {
            this.handleInterruption(exception);
            throw new SidecarApiCallException("Failed to create restore slice. restoreJobId=" + String.valueOf(jobId) + " payload=" + String.valueOf(createSliceRequestPayload), (Throwable)exception);
        }
    }

    @Override
    public CompletableFuture<Void> createRestoreSliceFromDriver(SidecarInstance sidecarInstance, CreateSliceRequestPayload createSliceRequestPayload) {
        return this.createRestoreSliceWithCustomRetry(sidecarInstance, createSliceRequestPayload, new DriverCreateSliceRetryPolicy(this.sidecarClient.defaultRetryPolicy()));
    }

    @Override
    public void updateRestoreJob(UpdateRestoreJobRequestPayload updateRestoreJobRequestPayload) throws SidecarApiCallException {
        UUID jobId = this.jobInfo.getRestoreJobId(this.clusterId);
        try {
            LOGGER.info("Updating the restore job. clusterId={} restoreJobId={}", (Object)this.clusterId, (Object)jobId);
            QualifiedTableName qualifiedTableName = this.jobInfo.qualifiedTableName();
            this.sidecarClient.updateRestoreJob(qualifiedTableName.keyspace(), qualifiedTableName.table(), jobId, updateRestoreJobRequestPayload).get();
        }
        catch (Exception exception) {
            this.handleInterruption(exception);
            throw new SidecarApiCallException("Failed to update restore job. restoreJobId=" + String.valueOf(jobId), (Throwable)exception);
        }
    }

    @Override
    public void abortRestoreJob() throws SidecarApiCallException {
        UUID jobId = this.jobInfo.getRestoreJobId(this.clusterId);
        try {
            LOGGER.info("Abort job. clusterId={} restoreJobId={}", (Object)this.clusterId, (Object)jobId);
            QualifiedTableName qualifiedTableName = this.jobInfo.qualifiedTableName();
            this.sidecarClient.abortRestoreJob(qualifiedTableName.keyspace(), qualifiedTableName.table(), jobId).get();
        }
        catch (Exception exception) {
            this.handleInterruption(exception);
            throw new SidecarApiCallException("Failed to abort restore job. restoreJobId=" + String.valueOf(jobId), (Throwable)exception);
        }
    }

    private CompletableFuture<Void> createRestoreSliceWithCustomRetry(SidecarInstance sidecarInstance, CreateSliceRequestPayload createSliceRequestPayload, RetryPolicy retryPolicy) {
        QualifiedTableName qualifiedTableName = this.jobInfo.qualifiedTableName();
        CreateRestoreJobSliceRequest request = new CreateRestoreJobSliceRequest(qualifiedTableName.keyspace(), qualifiedTableName.table(), this.jobInfo.getRestoreJobId(this.clusterId), createSliceRequestPayload);
        return this.sidecarClient.executeRequestAsync(this.sidecarClient.requestBuilder().retryPolicy(retryPolicy).singleInstanceSelectionPolicy(sidecarInstance).request((Request)request).build());
    }

    static class DriverCreateSliceRetryPolicy
    extends RetryPolicy {
        private static final Logger LOGGER = LoggerFactory.getLogger(DriverCreateSliceRetryPolicy.class);
        private final RetryPolicy delegate;

        DriverCreateSliceRetryPolicy(RetryPolicy delegate) {
            this.delegate = delegate;
        }

        public void onResponse(CompletableFuture<HttpResponse> completableFuture, Request request, HttpResponse httpResponse, Throwable throwable, int attempts, boolean canRetryOnADifferentHost, RetryAction retryAction) {
            if (httpResponse != null && httpResponse.statusCode() == HttpResponseStatus.CREATED.code()) {
                LOGGER.info("Received CREATED(201) for CreateSliceRequest. Changing the status code to ACCEPTED(202) for unlimited retry.");
                HttpResponseImpl fakeResponseForRetry = new HttpResponseImpl(HttpResponseStatus.ACCEPTED.code(), httpResponse.statusMessage(), httpResponse.headers(), httpResponse.sidecarInstance());
                this.delegate.onResponse(completableFuture, request, (HttpResponse)fakeResponseForRetry, throwable, attempts, canRetryOnADifferentHost, retryAction);
            } else {
                this.delegate.onResponse(completableFuture, request, httpResponse, throwable, attempts, canRetryOnADifferentHost, retryAction);
            }
        }
    }

    public static class ExecutorCreateSliceRetryPolicy
    extends RetryPolicy {
        private final SidecarClient sidecarClient;

        public ExecutorCreateSliceRetryPolicy(SidecarClient sidecarClient) {
            this.sidecarClient = sidecarClient;
        }

        public void onResponse(CompletableFuture<HttpResponse> completableFuture, Request request, HttpResponse httpResponse, Throwable throwable, int attempts, boolean canRetryOnADifferentHost, RetryAction retryAction) {
            if (httpResponse != null && httpResponse.statusCode() == HttpResponseStatus.CREATED.code()) {
                completableFuture.complete(httpResponse);
            } else {
                this.sidecarClient.defaultRetryPolicy().onResponse(completableFuture, request, httpResponse, throwable, attempts, canRetryOnADifferentHost, retryAction);
            }
        }
    }
}

