/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.token;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import o.a.c.sidecar.client.shaded.common.response.TokenRangeReplicasResponse;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRangeMapping<I extends CassandraInstance>
implements Serializable {
    private static final long serialVersionUID = -7284933683815811160L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenRangeMapping.class);
    private final Partitioner partitioner;
    private final transient Set<I> allInstances;
    private final transient Set<I> pendingInstances;
    private final transient RangeMap<BigInteger, List<I>> instancesByTokenRange;
    private final transient Multimap<I, Range<BigInteger>> tokenRangeMap;

    public static <I extends CassandraInstance> TokenRangeMapping<I> create(Supplier<TokenRangeReplicasResponse> topologySupplier, Supplier<Partitioner> partitionerSupplier, Function<TokenRangeReplicasResponse.ReplicaMetadata, I> instanceCreator) {
        TokenRangeReplicasResponse response = topologySupplier.get();
        HashMap instanceByIpAddress = new HashMap(response.replicaMetadata().size());
        response.replicaMetadata().forEach((ipAddress, metadata) -> instanceByIpAddress.put(ipAddress, (CassandraInstance)instanceCreator.apply((TokenRangeReplicasResponse.ReplicaMetadata)metadata)));
        Multimap tokenRangesByInstance = TokenRangeMapping.tokenRangesByInstance(response.writeReplicas(), instanceByIpAddress);
        HashSet allInstances = new HashSet(instanceByIpAddress.values());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Fetched token-range replicas: {}", allInstances);
        }
        return new TokenRangeMapping(partitionerSupplier.get(), tokenRangesByInstance, allInstances);
    }

    public static <I extends CassandraInstance> TokenRangeMapping<I> consolidate(@NotNull List<TokenRangeMapping<I>> all) {
        Preconditions.checkArgument((!all.isEmpty() ? 1 : 0) != 0, (Object)"Cannot consolidate TokenRangeMapping from none");
        if (all.size() == 1) {
            return all.get(0);
        }
        Set partitioners = all.stream().map(t -> t.partitioner).collect(Collectors.toSet());
        Preconditions.checkArgument((partitioners.size() == 1 ? 1 : 0) != 0, (Object)("Multiple Partitioners found: " + String.valueOf(partitioners)));
        Partitioner partitioner = all.get((int)0).partitioner;
        HashSet<I> allInstances = new HashSet<I>();
        ArrayListMultimap tokenRangesByInstance = ArrayListMultimap.create();
        for (TokenRangeMapping<I> topology : all) {
            allInstances.addAll(topology.allInstances);
            tokenRangesByInstance.putAll(topology.getTokenRanges());
        }
        return new TokenRangeMapping(partitioner, tokenRangesByInstance, allInstances);
    }

    private static <I extends CassandraInstance> Multimap<I, Range<BigInteger>> tokenRangesByInstance(List<TokenRangeReplicasResponse.ReplicaInfo> writeReplicas, Map<String, I> instanceByIpAddress) {
        ArrayListMultimap instanceToRangeMap = ArrayListMultimap.create();
        for (TokenRangeReplicasResponse.ReplicaInfo rInfo : writeReplicas) {
            Range range = Range.openClosed((Comparable)new BigInteger(rInfo.start()), (Comparable)new BigInteger(rInfo.end()));
            for (Map.Entry dcReplicaEntry : rInfo.replicasByDatacenter().entrySet()) {
                ((List)dcReplicaEntry.getValue()).forEach(arg_0 -> TokenRangeMapping.lambda$tokenRangesByInstance$2(instanceByIpAddress, (Multimap)instanceToRangeMap, range, arg_0));
            }
        }
        return instanceToRangeMap;
    }

    public TokenRangeMapping(Partitioner partitioner, Multimap<I, Range<BigInteger>> tokenRanges, Set<I> allInstances) {
        this.partitioner = partitioner;
        this.tokenRangeMap = tokenRanges;
        this.allInstances = allInstances;
        this.pendingInstances = allInstances.stream().filter(i -> i.nodeState().isPending).collect(Collectors.toSet());
        this.instancesByTokenRange = this.populateRangeReplicas();
    }

    public Partitioner partitioner() {
        return this.partitioner;
    }

    private static <I extends CassandraInstance> void addReplica(I instance, Range<BigInteger> range, RangeMap<BigInteger, List<I>> replicaMap) {
        Preconditions.checkArgument((((BigInteger)range.lowerEndpoint()).compareTo((BigInteger)range.upperEndpoint()) <= 0 ? 1 : 0) != 0, (Object)"Range calculations assume range is not wrapped");
        RangeMap replicaRanges = replicaMap.subRangeMap(range);
        TreeRangeMap mappingsToAdd = TreeRangeMap.create();
        replicaRanges.asMapOfRanges().forEach((arg_0, arg_1) -> TokenRangeMapping.lambda$addReplica$4(instance, (RangeMap)mappingsToAdd, arg_0, arg_1));
        replicaMap.putAll((RangeMap)mappingsToAdd);
    }

    public Set<I> allInstances() {
        return this.allInstances;
    }

    public Set<I> pendingInstances() {
        return this.pendingInstances;
    }

    @VisibleForTesting
    public Map<Range<BigInteger>, Set<I>> getWriteReplicasOfRange(Range<BigInteger> range, @Nullable String localDc) {
        return this.getWriteReplicasOfRange(range, (I instance) -> instance.datacenter().equalsIgnoreCase(localDc));
    }

    public Map<Range<BigInteger>, Set<I>> getWriteReplicasOfRange(Range<BigInteger> range, @Nullable Predicate<I> instanceFilter) {
        Map subRangeReplicas = this.instancesByTokenRange.subRangeMap(range).asMapOfRanges();
        Function<List, Set> filterAndTransform = instances -> {
            if (instanceFilter != null) {
                return instances.stream().filter(instanceFilter).collect(Collectors.toSet());
            }
            return new HashSet(instances);
        };
        return subRangeReplicas.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Set)filterAndTransform.apply((List)entry.getValue())));
    }

    public RangeMap<BigInteger, List<I>> getRangeMap() {
        return this.instancesByTokenRange;
    }

    public RangeMap<BigInteger, List<I>> getSubRanges(Range<BigInteger> tokenRange) {
        return this.instancesByTokenRange.subRangeMap(tokenRange);
    }

    public Multimap<I, Range<BigInteger>> getTokenRanges() {
        return this.tokenRangeMap;
    }

    private RangeMap<BigInteger, List<I>> populateRangeReplicas() {
        TreeRangeMap replicaRangeMap = TreeRangeMap.create();
        replicaRangeMap.put(Range.openClosed((Comparable)this.partitioner.minToken(), (Comparable)this.partitioner.maxToken()), Collections.emptyList());
        this.tokenRangeMap.asMap().forEach((arg_0, arg_1) -> TokenRangeMapping.lambda$populateRangeReplicas$9((RangeMap)replicaRangeMap, arg_0, arg_1));
        return replicaRangeMap;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TokenRangeMapping that = (TokenRangeMapping)other;
        return this.partitioner == that.partitioner && this.allInstances.equals(that.allInstances) && this.pendingInstances.equals(that.pendingInstances);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partitioner, this.tokenRangeMap, this.allInstances, this.pendingInstances, this.instancesByTokenRange});
    }

    private static /* synthetic */ void lambda$populateRangeReplicas$9(RangeMap replicaRangeMap, CassandraInstance inst, Collection ranges) {
        ranges.forEach(range -> TokenRangeMapping.addReplica(inst, (Range<BigInteger>)range, replicaRangeMap));
    }

    private static /* synthetic */ void lambda$addReplica$4(CassandraInstance instance, RangeMap mappingsToAdd, Range key, List value) {
        ArrayList<CassandraInstance> replicas = new ArrayList<CassandraInstance>(value);
        replicas.add(instance);
        mappingsToAdd.put(key, replicas);
    }

    private static /* synthetic */ void lambda$tokenRangesByInstance$2(Map instanceByIpAddress, Multimap instanceToRangeMap, Range range, String ipAddress) {
        if (!instanceByIpAddress.containsKey(ipAddress)) {
            throw new RuntimeException(String.format("No metadata found for instance: %s", ipAddress));
        }
        instanceToRangeMap.put((Object)((CassandraInstance)instanceByIpAddress.get(ipAddress)), (Object)range);
    }
}

