/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Set;
import org.apache.cassandra.spark.bulkwriter.BulkWriterConfig;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.TokenPartitioner;
import org.apache.cassandra.spark.bulkwriter.util.SbwJavaSerializer;
import org.apache.cassandra.spark.transports.storage.StorageAccessConfiguration;
import org.apache.cassandra.spark.transports.storage.StorageCredentials;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportConfiguration;
import org.apache.spark.SparkConf;
import org.apache.spark.serializer.KryoRegistrator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SbwKryoRegistrator
implements KryoRegistrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SbwKryoRegistrator.class);
    protected static final String KRYO_KEY = "spark.kryo.registrator";
    private static final Set<Class<?>> javaSerializableClasses = Sets.newHashSet((Object[])new Class[]{RingInstance.class, TokenPartitioner.class, BulkWriterConfig.class});

    public void registerClasses(@NotNull Kryo kryo) {
        LOGGER.debug("Registering Spark Bulk Writer classes with Kryo which require use of Java Serializer");
        javaSerializableClasses.stream().sorted(Comparator.comparing(Class::getCanonicalName)).forEach(javaSerializableClass -> kryo.register(javaSerializableClass, (Serializer)new SbwJavaSerializer()));
        kryo.register(StorageTransportConfiguration.class, (Serializer)new StorageTransportConfiguration.Serializer());
        kryo.register(StorageAccessConfiguration.class, (Serializer)new StorageAccessConfiguration.Serializer());
        kryo.register(StorageCredentials.class, (Serializer)new StorageCredentials.Serializer());
    }

    public static void addJavaSerializableClass(@NotNull Class<?> javaSerializableClass) {
        javaSerializableClasses.add(javaSerializableClass);
    }

    public static void setupKryoRegistrator(@NotNull SparkConf configuration) {
        String registrator;
        String registrators = configuration.get(KRYO_KEY, "");
        if (!registrators.contains(registrator = SbwKryoRegistrator.class.getName())) {
            configuration.set(KRYO_KEY, registrators + "," + registrator);
        }
    }
}

