/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.common.schema;

import java.nio.ByteBuffer;
import org.apache.cassandra.spark.common.schema.ColumnType;

public final class ColumnUtil {
    private ColumnUtil() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    private static int getLength(ByteBuffer buffer) {
        if (buffer.remaining() < 2) {
            return 0;
        }
        short length = buffer.getShort();
        if (buffer.remaining() < length) {
            throw new IllegalArgumentException("Invalid buffer length, expecting " + length + " bytes but got " + buffer.remaining());
        }
        return length;
    }

    public static <T> T getField(ByteBuffer buffer, ColumnType<T> column) {
        return column.parseColumn(buffer, ColumnUtil.getLength(buffer));
    }

    public static <T> T parseSingleColumn(ColumnType<T> column, ByteBuffer buffer) {
        return column.parseColumn(buffer, buffer.remaining());
    }
}

