/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.sidecar;

import java.io.IOException;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.cdc.Cdc;
import org.apache.cassandra.cdc.CdcBuilder;
import org.apache.cassandra.cdc.api.CdcOptions;
import org.apache.cassandra.cdc.api.EventConsumer;
import org.apache.cassandra.cdc.api.SchemaSupplier;
import org.apache.cassandra.cdc.api.TokenRangeSupplier;
import org.apache.cassandra.cdc.sidecar.CdcSidecarInstancesProvider;
import org.apache.cassandra.cdc.sidecar.ClusterConfigProvider;
import org.apache.cassandra.cdc.sidecar.SidecarCdcBuilder;
import org.apache.cassandra.cdc.sidecar.SidecarCdcClient;
import org.apache.cassandra.cdc.stats.ICdcStats;
import org.apache.cassandra.secrets.SecretsProvider;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.utils.FutureUtils;
import org.jetbrains.annotations.NotNull;

public class SidecarCdc
extends Cdc {
    protected final ClusterConfigProvider clusterConfigProvider;

    protected SidecarCdc(@NotNull SidecarCdcBuilder builder) {
        super((CdcBuilder)builder);
        this.clusterConfigProvider = builder.clusterConfigProvider;
        this.initSchema();
    }

    public static SidecarCdcBuilder builder(@NotNull String jobId, int partitionId, CdcOptions cdcOptions, ClusterConfigProvider clusterConfigProvider, EventConsumer eventConsumer, SchemaSupplier schemaSupplier, TokenRangeSupplier tokenRangeSupplier, CdcSidecarInstancesProvider sidecarInstancesProvider, SidecarCdcClient.ClientConfig clientConfig, SecretsProvider secretsProvider, ICdcStats cdcStats) throws IOException {
        return new SidecarCdcBuilder(jobId, partitionId, cdcOptions, clusterConfigProvider, eventConsumer, schemaSupplier, tokenRangeSupplier, sidecarInstancesProvider, clientConfig, secretsProvider, cdcStats);
    }

    public void initSchema() {
        Set tables = (Set)FutureUtils.get((CompletableFuture)this.schemaSupplier.getCdcEnabledTables());
        Optional<ReplicationFactor> rfOp = tables.stream().map(CqlTable::replicationFactor).filter(rf -> rf.getOptions().containsKey(this.dc())).max(Comparator.comparingInt(rf -> (Integer)rf.getOptions().get(this.dc())));
        if (!rfOp.isPresent()) {
            throw new RuntimeException("Could not find replication factor for any keyspace");
        }
    }

    public String dc() {
        return this.clusterConfigProvider.dc();
    }
}

