/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.complex;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.serializers.ListSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlType;
import org.apache.cassandra.spark.data.complex.CqlCollection;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.apache.cassandra.utils.UUIDGen;

public abstract class AbstractCqlList
extends CqlCollection
implements CqlField.CqlList {
    public AbstractCqlList(CqlField.CqlType type) {
        super(type);
    }

    @Override
    public AbstractType<?> dataType(boolean isMultiCell) {
        return ListType.getInstance(((CqlType)this.type()).dataType(), (boolean)isMultiCell);
    }

    public CqlField.CqlType.InternalType internalType() {
        return CqlField.CqlType.InternalType.List;
    }

    @Override
    public <T> TypeSerializer<T> serializer() {
        return ListSerializer.getInstance(((CqlType)this.type()).serializer());
    }

    public String name() {
        return "list";
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setList(position, (List)value);
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return IntStream.range(0, RandomUtils.RANDOM.nextInt(16) + minCollectionSize).mapToObj(element -> this.type().randomValue(minCollectionSize)).collect(Collectors.toList());
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return DataType.list((DataType)((CqlType)this.type()).driverDataType(isFrozen));
    }

    public Object convertForCqlWriter(Object value, CassandraVersion version, boolean isCollectionElement) {
        return ((List)value).stream().map(element -> this.type().convertForCqlWriter(element, version, true)).collect(Collectors.toList());
    }

    @Override
    public void addCell(Row.Builder rowBuilder, ColumnMetadata cd, long timestamp, int ttl, int now, Object value) {
        for (Object o : (List)value) {
            if (ttl != 0) {
                rowBuilder.addCell((Cell)BufferCell.expiring((ColumnMetadata)cd, (long)timestamp, (int)ttl, (int)now, (ByteBuffer)this.type().serialize(o), (CellPath)CellPath.create((ByteBuffer)ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes()))));
                continue;
            }
            rowBuilder.addCell((Cell)BufferCell.live((ColumnMetadata)cd, (long)timestamp, (ByteBuffer)this.type().serialize(o), (CellPath)this.randomCellPath()));
        }
    }

    protected abstract CellPath randomCellPath();
}

