/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.cassandra.spark.utils.streaming.BufferingInputStream;

public class ReadOnlyInputStreamFileChannel
extends FileChannel {
    private BufferingInputStream<?> inputStream;
    private final long size;
    private long position;

    public ReadOnlyInputStreamFileChannel(BufferingInputStream<?> inputStream, long size) {
        this.inputStream = inputStream;
        this.size = size;
        this.position = 0L;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int streamRemaining = Math.toIntExact(Math.min(this.size - this.position, Integer.MAX_VALUE));
        int newLimit = dst.position() + Math.min(streamRemaining, dst.remaining());
        dst.limit(Math.min(newLimit, dst.capacity()));
        int read = this.inputStream.read(dst);
        this.position += (long)read;
        if (dst.position() == 0 && dst.limit() > 0) {
            dst.position(read);
        }
        return read;
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        if (this.size <= position) {
            return -1;
        }
        if (this.position != position) {
            this.position(position);
        }
        return this.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public long size() throws IOException {
        return this.size;
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        if (newPosition != this.position) {
            this.inputStream = this.inputStream.reBuffer(newPosition);
            this.position = newPosition;
        }
        return this;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException("This is a read only channel");
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("This is a read only channel");
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        throw new UnsupportedOperationException("This is a read only channel");
    }

    @Override
    public void force(boolean metaData) throws IOException {
        throw new UnsupportedOperationException("This is a read only channel");
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        throw new UnsupportedOperationException("This channel does not support transferring");
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        throw new UnsupportedOperationException("This is a read only channel");
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        throw new UnsupportedOperationException("This is a read only channel");
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException("Mapping is not supported by this channel");
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException("This is a read only channel");
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException("This is a read only channel");
    }

    @Override
    protected void implCloseChannel() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

