/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.avro;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.cassandra.cdc.avro.AvroSchemas;
import org.apache.cassandra.cdc.avro.TypeConversion;

public class TypeConversionRegistry
implements TypeConversion.Registry {
    private final Map<TypeConversion.TypeMapping, TypeConversion<?>> conversions = new HashMap();

    @Override
    public void register(TypeConversion<?> typeConversion) {
        this.conversions.put(typeConversion.typeMapping(), typeConversion);
    }

    @Override
    public TypeConversion<?> lookup(Schema fieldSchema) {
        LogicalType logicalType = fieldSchema.getLogicalType();
        if (logicalType == null) {
            return fieldSchema.getType() == Schema.Type.ARRAY ? this.conversions.get(TypeConversion.ListConversion.LIST_IDENTITY_MAPPING) : null;
        }
        boolean useAvroTypeName = fieldSchema.getType() == Schema.Type.ARRAY || fieldSchema.getType() == Schema.Type.RECORD || Objects.equals(logicalType.getName(), "uuid");
        TypeConversion.TypeMapping mapping = TypeConversion.TypeMapping.of(fieldSchema.getType().getName(), logicalType.getName(), useAvroTypeName ? logicalType.getName() : AvroSchemas.cqlType((Schema)fieldSchema));
        return this.conversions.get(mapping);
    }
}

