/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.client;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import o.a.c.sidecar.client.shaded.client.RequestExecutor;
import o.a.c.sidecar.client.shaded.client.VertxHttpClient;
import o.a.c.sidecar.client.shaded.io.vertx.core.Vertx;

public class VertxRequestExecutor
extends RequestExecutor {
    private final Vertx vertx;

    public VertxRequestExecutor(VertxHttpClient httpClient) {
        super(httpClient);
        this.vertx = Objects.requireNonNull(httpClient.vertx(), "The vertx instance is required");
    }

    @Override
    protected void schedule(long delayMillis, Runnable runnable) {
        if (delayMillis > 0L) {
            this.vertx.setTimer(delayMillis, p -> runnable.run());
        } else {
            runnable.run();
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        try {
            this.vertx.close().toCompletionStage().toCompletableFuture().get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.logger.warn("Failed to close vertx after 1 minute", (Throwable)exception);
        }
    }
}

